/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.microedition.svg.DataListener;
import org.netbeans.microedition.svg.SVGComponent;
import org.netbeans.microedition.svg.SVGDefaultListCellRenderer;
import org.netbeans.microedition.svg.SVGForm;
import org.netbeans.microedition.svg.SVGListCellRenderer;
import org.netbeans.microedition.svg.SVGRectangle;
import org.netbeans.microedition.svg.input.InputHandler;
import org.netbeans.microedition.svg.input.PointerEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGRect;

public class SVGList
extends SVGComponent
implements DataListener {
    private static final String CONTENT = "content";
    private static final String SELECTION = "selection";
    private static final String CUR_SELECTION = "current_selection";
    private static final String HIDDEN_TEXT = "hidden_text";
    private static final String BOUNDS = "bound";
    private static final String CONTENT_SUFFIX = "_content";
    private static final String SELECTION_SUFFIX = "_selection";
    private static final String CUR_SELECTION_SUFFIX = "_current_selection";
    private static final String BOUNDS_SUFIX = "_bound";
    private static final String HIDDEN_TEXT_SUFFIX = "_hidden_text";
    private SVGListCellRenderer myRenderer;
    private ListModel myModel;
    private SelectionModel mySelectionModel;
    private InputHandler myHandler;
    private SVGLocatableElement myHiddenText;
    private SVGLocatableElement myContent;
    private SVGLocatableElement mySelection;
    private SVGLocatableElement myCurrentSelection;
    private SVGLocatableElement myBounds;
    private int myTopIndex;
    private int myCurrentIndex;
    private int myCount = -1;
    private boolean isUIAction;
    private Object myUILock = new Object();
    private Vector myRenderedComponents;
    private boolean isSlave;

    public SVGList(SVGForm form, SVGLocatableElement element) {
        super(form, element);
        this.initNestedElements();
        this.verify();
        if (this.myHiddenText != null) {
            float height = this.myHiddenText.getFloatTrait("font-size");
            this.myCount = (int)(this.myBounds.getBBox().getHeight() / height);
            this.setRenderer(new SVGDefaultListCellRenderer(height, form, this.myHiddenText));
        }
        this.isSlave = "hidden".equals(this.getElement().getTrait("visibility"));
        this.myRenderedComponents = new Vector();
        this.setSelectionModel(new DefaultSelectionModel());
        this.myHandler = new ListHandler();
        this.setModel(new DefaultListModel(new Vector()));
    }

    public SVGList(SVGForm form, String elemId) {
        this(form, (SVGLocatableElement)form.getDocument().getElementById(elemId));
    }

    public SVGListCellRenderer getRenderer() {
        return this.myRenderer;
    }

    public ListModel getModel() {
        return this.myModel;
    }

    public void setModel(ListModel model) {
        if (this.myModel != null) {
            this.myModel.removeDataListener(this);
        }
        this.myModel = model;
        this.myModel.addDataListener(this);
        if (model.getSize() > 0) {
            this.getSelectionModel().addSelectionInterval(0, 0);
        }
        this.renderList();
    }

    public void setRenderer(SVGListCellRenderer renderer) {
        this.myRenderer = renderer;
    }

    public SelectionModel getSelectionModel() {
        return this.mySelectionModel;
    }

    public void setSelectionModel(SelectionModel model) {
        if (this.mySelectionModel != null) {
            this.mySelectionModel.removeDataListener(this);
        }
        this.mySelectionModel = model;
        this.mySelectionModel.addDataListener(this);
    }

    public InputHandler getInputHandler() {
        return this.myHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contentsChanged(Object source) {
        if (source == this.getSelectionModel()) {
            Object object = this.myUILock;
            synchronized (object) {
                if (!this.isUIAction) {
                    if (this.getSelectionModel().getSelectedIndex() != -1) {
                        this.myCurrentIndex = this.getSelectionModel().getSelectedIndex();
                    }
                    this.renderList();
                }
            }
        } else if (source == this.getModel()) {
            this.renderList();
        }
    }

    SVGLocatableElement getBoundsElement() {
        return this.myBounds;
    }

    SVGLocatableElement getHiddenText() {
        return this.myHiddenText;
    }

    SVGLocatableElement getContent() {
        return this.myContent;
    }

    SVGLocatableElement getSelection() {
        return this.mySelection;
    }

    SVGLocatableElement getCurrentSelection() {
        return this.myCurrentSelection;
    }

    boolean isSlave() {
        return this.isSlave;
    }

    private void initNestedElements() {
        if (this.getElement().getId() != null) {
            this.myHiddenText = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + HIDDEN_TEXT_SUFFIX);
            this.myBounds = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + BOUNDS_SUFIX);
            this.myContent = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + CONTENT_SUFFIX);
            this.mySelection = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + SELECTION_SUFFIX);
            this.myCurrentSelection = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + CUR_SELECTION_SUFFIX);
        }
        if (this.myHiddenText == null) {
            this.myHiddenText = (SVGLocatableElement)this.getNestedElementByMeta((SVGElement)this.getElement(), "type", HIDDEN_TEXT);
        }
        if (this.myBounds == null) {
            this.myBounds = (SVGLocatableElement)this.getNestedElementByMeta((SVGElement)this.getElement(), "type", BOUNDS);
        }
        if (this.myContent == null) {
            this.myContent = (SVGLocatableElement)this.getElementByMeta((SVGElement)this.getElement(), "type", CONTENT);
        }
        if (this.mySelection == null) {
            this.mySelection = (SVGLocatableElement)this.getElementByMeta((SVGElement)this.getElement(), "type", SELECTION);
        }
        if (this.myCurrentSelection == null) {
            this.myCurrentSelection = (SVGLocatableElement)this.getElementByMeta((SVGElement)this.getElement(), "type", CUR_SELECTION);
        }
    }

    private void verify() {
        if (this.myBounds == null) {
            throw new IllegalArgumentException("Element with id=" + this.getElement().getId() + " couldn't be List element" + " becuase it doesn't contain nested 'bound' " + "element. See javadoc for SVG snippet.");
        }
        if (this.myContent == null) {
            throw new IllegalArgumentException("Element with id=" + this.getElement().getId() + " couldn't be List element" + " becuase it doesn't contain nested 'content' " + " element. See javadoc for SVG snippet.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderList() {
        SVGList sVGList = this;
        synchronized (sVGList) {
            if (this.myCount != -1 && this.myCurrentIndex >= this.myTopIndex + this.myCount) {
                this.myTopIndex = this.myCurrentIndex - this.myCount + 1;
            } else if (this.myCurrentIndex < this.myTopIndex) {
                this.myTopIndex = this.myCurrentIndex;
            }
        }
        this.doRenderList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderList(int deltaTopIndex) {
        SVGList sVGList = this;
        synchronized (sVGList) {
            int topIndex = this.myTopIndex;
            if ((topIndex += deltaTopIndex) < 0) {
                topIndex = 0;
            }
            if (topIndex >= this.getModel().getSize() - this.myCount) {
                topIndex = this.getModel().getSize() - this.myCount;
            }
            if (topIndex == this.myTopIndex) {
                return;
            }
            this.myTopIndex = topIndex;
        }
        this.doRenderList();
    }

    private void doRenderList() {
        final int top = this.myTopIndex;
        final int currentIndex = this.myCurrentIndex;
        this.getForm().invokeLaterSafely(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SVGList.this.removeContent();
                ListModel model = SVGList.this.getModel();
                int size = model.getSize();
                if (size == 0) {
                    return;
                }
                SVGListCellRenderer renderer = SVGList.this.getRenderer();
                Vector<SVGComponent> vector = new Vector<SVGComponent>();
                int i = top;
                do {
                    SVGComponent comp = renderer.getCellRendererComponent(SVGList.this, model.getElementAt(i), i - top, SVGList.this.getSelectionModel().isSelectedIndex(i), i == currentIndex);
                    vector.addElement(comp);
                    SVGRectangle rectangle = comp.getBounds();
                    if (SVGList.this.myCount != -1 || i != top) continue;
                    SVGList.this.myCount = (int)(SVGList.this.myBounds.getBBox().getHeight() / rectangle.getHeight());
                } while (++i < Math.min(top + SVGList.this.myCount, size));
                SVGList sVGList = SVGList.this;
                synchronized (sVGList) {
                    SVGList.this.myRenderedComponents = vector;
                }
            }
        });
    }

    private void removeContent() {
        this.removeChildren(this.myCurrentSelection);
        this.removeChildren(this.myContent);
    }

    private void removeChildren(SVGLocatableElement element) {
        Element node = element.getFirstElementChild();
        while (node != null) {
            String display;
            Element next = null;
            if (node instanceof SVGElement) {
                next = ((SVGElement)node).getNextElementSibling();
            }
            if (!"text".equals(node.getLocalName())) {
                element.removeChild((Node)node);
            } else if (node instanceof SVGElement && !"none".equals(display = ((SVGElement)node).getTrait("display"))) {
                Element forRemove = node;
                element.removeChild((Node)forRemove);
            }
            node = next;
        }
    }

    public static class DefaultListModel
    implements ListModel {
        private Vector myData;
        private Vector myListeners = new Vector(1);

        public DefaultListModel(Vector data) {
            this.myData = new Vector();
            for (int i = 0; i < data.size(); ++i) {
                this.myData.addElement(data.elementAt(i));
            }
        }

        public Object getElementAt(int indx) {
            return this.myData.elementAt(indx);
        }

        public int getSize() {
            return this.myData.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDataListener(DataListener listener) {
            Vector vector = this.myListeners;
            synchronized (vector) {
                this.myListeners.addElement(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void removeDataListener(DataListener listener) {
            Vector vector = this.myListeners;
            synchronized (vector) {
                this.myListeners.removeElement(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireDataChanged() {
            Vector vector = this.myListeners;
            synchronized (vector) {
                Enumeration en = this.myListeners.elements();
                while (en.hasMoreElements()) {
                    DataListener listener = (DataListener)en.nextElement();
                    listener.contentsChanged(this);
                }
            }
        }
    }

    private class DefaultSelectionModel
    implements SelectionModel {
        private Vector mySelectedIndeces;
        private Vector myListeners = new Vector(1);
        private int myMode;

        DefaultSelectionModel() {
            this.setSelectionMode(0);
        }

        public boolean isSelectedIndex(int index) {
            return this.mySelectedIndeces.contains(new Integer(index));
        }

        public void addSelectionInterval(int from, int to) {
            if (this.getSelectionMode() == 0) {
                this.doClearSelection();
            }
            if (from <= to) {
                for (int i = from; i <= to; ++i) {
                    this.mySelectedIndeces.addElement(new Integer(i));
                }
            } else {
                for (int i = to; i <= from; ++i) {
                    this.mySelectedIndeces.addElement(new Integer(i));
                }
            }
            this.fireDataChanged();
        }

        public void clearSelection() {
            this.doClearSelection();
            this.fireDataChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDataListener(DataListener listener) {
            Vector vector = this.myListeners;
            synchronized (vector) {
                this.myListeners.addElement(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDataListener(DataListener listener) {
            Vector vector = this.myListeners;
            synchronized (vector) {
                this.myListeners.removeElement(listener);
            }
        }

        public int getSelectionMode() {
            return this.myMode;
        }

        public void setSelectionMode(int mode) {
            this.myMode = mode;
            this.mySelectedIndeces = mode == 0 ? new Vector(1) : new Vector();
        }

        public int getSelectedIndex() {
            if (this.mySelectedIndeces.isEmpty()) {
                return -1;
            }
            Integer index = (Integer)this.mySelectedIndeces.elementAt(0);
            return index;
        }

        public void removeSelectionInterval(int from, int to) {
            if (this.mySelectedIndeces.isEmpty()) {
                return;
            }
            int begin = from <= to ? from : to;
            int end = from <= to ? to : from;
            int i = 0;
            while (i < this.mySelectedIndeces.size()) {
                Integer index = (Integer)this.mySelectedIndeces.elementAt(i);
                if (begin <= index && index <= end) {
                    this.mySelectedIndeces.removeElementAt(i);
                    continue;
                }
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireDataChanged() {
            Vector vector = this.myListeners;
            synchronized (vector) {
                Enumeration en = this.myListeners.elements();
                while (en.hasMoreElements()) {
                    DataListener listener = (DataListener)en.nextElement();
                    listener.contentsChanged(this);
                }
            }
        }

        private void doClearSelection() {
            this.mySelectedIndeces.removeAllElements();
        }
    }

    private class ListHandler
    extends InputHandler {
        private int myPressedIndex = 0;
        private SVGComponent myPressedComponent;
        private float myPressedY;

        private ListHandler() {
        }

        public boolean handleKeyPress(SVGComponent comp, int keyCode) {
            return comp instanceof SVGList && (keyCode == -3 || keyCode == -4 || keyCode == -5);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleKeyRelease(SVGComponent comp, int keyCode) {
            boolean ret = false;
            if (comp instanceof SVGList) {
                if (keyCode == -3) {
                    SVGList.this.myCurrentIndex = Math.max(0, SVGList.this.myCurrentIndex - 1);
                    Object object = SVGList.this.myUILock;
                    synchronized (object) {
                        SVGList.this.isUIAction = true;
                        SVGList.this.getSelectionModel().clearSelection();
                        SVGList.this.getSelectionModel().addSelectionInterval(SVGList.this.myCurrentIndex, SVGList.this.myCurrentIndex);
                        SVGList.this.isUIAction = false;
                    }
                    SVGList.this.renderList();
                    ret = true;
                } else if (keyCode == -4) {
                    SVGList.this.myCurrentIndex = Math.min(SVGList.this.myCurrentIndex + 1, SVGList.this.getModel().getSize() - 1);
                    Object object = SVGList.this.myUILock;
                    synchronized (object) {
                        SVGList.this.isUIAction = true;
                        SVGList.this.getSelectionModel().clearSelection();
                        SVGList.this.getSelectionModel().addSelectionInterval(SVGList.this.myCurrentIndex, SVGList.this.myCurrentIndex);
                        SVGList.this.isUIAction = false;
                    }
                    SVGList.this.renderList();
                    ret = true;
                } else if (keyCode == -5) {
                    SVGList.this.fireActionPerformed();
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handlePointerPress(PointerEvent event) {
            SVGList.this.requestFocus();
            if (SVGList.this.mySelection.getScreenBBox() == null) {
                super.handlePointerPress(event);
                return;
            }
            SVGList sVGList = SVGList.this;
            synchronized (sVGList) {
                for (int i = 0; i < SVGList.this.myRenderedComponents.size(); ++i) {
                    SVGComponent component = (SVGComponent)SVGList.this.myRenderedComponents.elementAt(i);
                    SVGRectangle rect = component.getBounds();
                    if (rect == null) continue;
                    SVGRect selection = SVGList.this.mySelection.getScreenBBox();
                    if (selection.getHeight() == 0.0f) {
                        rect.setSize((int)SVGList.this.mySelection.getScreenBBox().getWidth(), (int)rect.getHeight());
                    } else {
                        rect.setSize((int)rect.getWidth(), (int)SVGList.this.mySelection.getScreenBBox().getHeight());
                    }
                    if (!rect.contains(event.getX(), event.getY())) continue;
                    this.myPressedIndex = i;
                    this.myPressedY = selection.getHeight() == 0.0f ? (float)event.getY() : (float)event.getX();
                    this.myPressedComponent = component;
                    break;
                }
            }
            super.handlePointerPress(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handlePointerRelease(PointerEvent event) {
            int index = this.myPressedIndex + SVGList.this.myTopIndex;
            if (this.myPressedComponent != null && this.myPressedComponent.getBounds() != null) {
                SVGRectangle rect = this.myPressedComponent.getBounds();
                if (SVGList.this.mySelection.getScreenBBox() != null) {
                    if (SVGList.this.mySelection.getScreenBBox().getHeight() == 0.0f) {
                        rect.setSize((int)SVGList.this.mySelection.getScreenBBox().getWidth(), (int)rect.getHeight());
                    } else {
                        rect.setSize((int)rect.getWidth(), (int)SVGList.this.mySelection.getScreenBBox().getHeight());
                    }
                    if (rect.contains(event.getX(), event.getY())) {
                        SVGList.this.myCurrentIndex = index;
                        Object object = SVGList.this.myUILock;
                        synchronized (object) {
                            SVGList.this.isUIAction = true;
                            this.doSelection();
                            SVGList.this.isUIAction = false;
                        }
                        SVGList.this.renderList();
                    } else {
                        int count = SVGList.this.mySelection.getScreenBBox().getHeight() == 0.0f ? (int)(((float)event.getY() - this.myPressedY) / rect.getHeight()) : (int)(((float)event.getX() - this.myPressedY) / rect.getWidth());
                        SVGList.this.renderList(count);
                    }
                }
            }
            super.handlePointerRelease(event);
            this.myPressedIndex = 0;
            this.myPressedComponent = null;
        }

        private void doSelection() {
            if (SVGList.this.getSelectionModel().getSelectionMode() == 0) {
                SVGList.this.getSelectionModel().addSelectionInterval(SVGList.this.myCurrentIndex, SVGList.this.myCurrentIndex);
            } else if (SVGList.this.getSelectionModel().getSelectionMode() == 1) {
                boolean isSelected = SVGList.this.getSelectionModel().isSelectedIndex(SVGList.this.myCurrentIndex);
                if (isSelected) {
                    SVGList.this.getSelectionModel().removeSelectionInterval(SVGList.this.myCurrentIndex, SVGList.this.myCurrentIndex);
                } else {
                    SVGList.this.getSelectionModel().addSelectionInterval(SVGList.this.myCurrentIndex, SVGList.this.myCurrentIndex);
                }
            }
        }
    }

    public static interface ListModel {
        public Object getElementAt(int var1);

        public int getSize();

        public void addDataListener(DataListener var1);

        public void removeDataListener(DataListener var1);
    }

    public static interface SelectionModel {
        public static final int SINGLE_SELECTION = 0;
        public static final int MULTIPLE_SELECTION = 1;

        public void clearSelection();

        public boolean isSelectedIndex(int var1);

        public void addSelectionInterval(int var1, int var2);

        public void removeSelectionInterval(int var1, int var2);

        public void addDataListener(DataListener var1);

        public void removeDataListener(DataListener var1);

        public int getSelectionMode();

        public void setSelectionMode(int var1);

        public int getSelectedIndex();
    }
}

