/*
 * Decompiled with CFR 0.152.
 */
public class Vector {
    public double x;
    public double y;
    public double z;

    public Vector() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vector(Point p) {
        this.x = p.x;
        this.y = p.y;
        this.z = 0.0;
    }

    public Vector(int _x, int _y) {
        this.x = _x;
        this.y = _y;
        this.z = 0.0;
    }

    public Vector(double _x, double _y) {
        this.x = _x;
        this.y = _y;
        this.z = 0.0;
    }

    public Vector(double _x, double _y, double _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
    }

    public double dist(Vector v) {
        return Math.sqrt((v.x - this.x) * (v.x - this.x) + (v.y - this.y) * (v.y - this.y) + (v.z - this.z) * (v.z - this.z));
    }

    public double dist(double X, double Y) {
        return Math.sqrt((X - this.x) * (X - this.x) + (Y - this.y) * (Y - this.y));
    }

    public double dist(Point p) {
        return Math.sqrt((p.x - this.x) * (p.x - this.x) + (p.y - this.y) * (p.y - this.y));
    }

    public Vector subtract(Vector v) {
        return new Vector(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public Vector add(Vector v) {
        return new Vector(v.x + this.x, v.y + this.y, v.z + this.z);
    }

    public void addTo(Vector v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public Vector unitV() {
        double mag = this.mag();
        return new Vector(this.x / mag, this.y / mag, this.z / mag);
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public String toString() {
        return new String("[" + this.x + "," + this.y + "," + this.z + "]");
    }

    public boolean equals(Vector v2) {
        return this.x == v2.x && this.y == v2.y && this.z == v2.z;
    }
}

