/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TouchButton {
    private int x;
    private int y;
    private int w = 0;
    private int h = 0;
    private int buffer;
    private boolean active;
    private boolean clicked;
    private boolean drawAsClicked;
    private long clickedAt;
    private long clickDuration;
    private String label;
    private Image icon;
    private Image inactiveIcon;
    private Color borderColor;
    private Color fillColor;
    private Color clickedColor;
    private Color inactiveBorderColor;
    private Color inactiveFillColor;
    private Color textColor;
    private Color inactiveTextColor;
    private Font myFont;
    private String commands;
    private SpringThing myBoss;
    private boolean updated = false;
    private Image render;
    private Graphics g;

    public TouchButton(String coms, Image _icon, int _x, int _y) {
        this.commands = coms;
        this.icon = _icon;
        this.inactiveIcon = this.dullImage(_icon);
        this.label = null;
        this.x = _x;
        this.y = _y;
        this.setDefaults();
    }

    public TouchButton(String coms, String _label, int _x, int _y) {
        this.commands = coms;
        this.label = _label;
        this.icon = null;
        this.x = _x;
        this.y = _y;
        this.setDefaults();
    }

    public void setDefaults() {
        this.borderColor = Color.RED;
        this.textColor = Color.RED;
        this.fillColor = Color.BLACK;
        this.clickedColor = Color.YELLOW;
        this.inactiveBorderColor = Color.LIGHT_GRAY;
        this.inactiveFillColor = Color.DARK_GRAY;
        this.inactiveTextColor = Color.LIGHT_GRAY;
        this.clickDuration = 100L;
        this.clickedAt = 0L;
        this.buffer = 3;
        this.drawAsClicked = false;
        this.clicked = false;
        this.active = true;
        this.updated = false;
        this.myFont = Font.getFont((int)32, (int)0, (int)8);
        this.autoSize();
        this.render = Image.createImage((int)this.w, (int)this.h);
        this.g = this.render.getGraphics();
    }

    public void activate() {
        this.active = true;
        this.clicked = false;
        this.drawAsClicked = false;
        this.updated = false;
    }

    public void deactivate() {
        this.active = false;
        this.clicked = false;
        this.drawAsClicked = false;
        this.updated = false;
    }

    public void toggleActive() {
        this.active = !this.active;
        this.clicked = false;
        this.drawAsClicked = false;
        this.updated = false;
    }

    public void setLabel(String s) {
        this.label = s;
        this.updated = false;
    }

    public void setIcon(Image _icon) {
        this.icon = _icon;
        this.inactiveIcon = this.dullImage(_icon);
        this.updated = false;
    }

    public void paint(Graphics g) {
        if (!this.updated || this.drawAsClicked && System.currentTimeMillis() - this.clickedAt > this.clickDuration) {
            this.update();
        }
        g.drawImage(this.render, this.x, this.y, 0);
    }

    private void update() {
        this.g.setFont(this.myFont);
        if (this.drawAsClicked) {
            if (System.currentTimeMillis() - this.clickedAt > this.clickDuration) {
                System.out.println("TouchButton: click draw timed out.");
                this.drawAsClicked = false;
                this.updated = false;
                this.update();
                return;
            }
            this.g.setColor(this.clickedColor.value);
            this.g.fillRect(0, 0, this.w, this.h);
            this.g.setColor(this.borderColor.value);
            this.g.drawRect(0, 0, this.w - 1, this.h - 1);
            if (this.icon == null) {
                this.g.setColor(this.textColor.value);
                this.g.drawString(this.label, this.buffer, this.buffer, 0);
            } else {
                this.g.drawImage(this.icon, this.buffer, this.buffer, 0);
            }
        } else if (this.active) {
            this.g.setColor(this.fillColor.value);
            this.g.fillRect(0, 0, this.w, this.h);
            this.g.setColor(this.borderColor.value);
            this.g.drawRect(0, 0, this.w - 1, this.h - 1);
            if (this.icon == null) {
                this.g.setColor(this.textColor.value);
                this.g.drawString(this.label, this.buffer, this.buffer, 0);
            } else {
                this.g.drawImage(this.icon, this.buffer, this.buffer, 0);
            }
        } else {
            this.g.setColor(this.inactiveFillColor.value);
            this.g.fillRect(0, 0, this.w, this.h);
            this.g.setColor(this.inactiveBorderColor.value);
            this.g.drawRect(0, 0, this.w - 1, this.h - 1);
            if (this.icon == null) {
                this.g.setColor(this.inactiveTextColor.value);
                this.g.drawString(this.label, this.buffer, this.buffer, 0);
            } else {
                this.g.drawImage(this.inactiveIcon, this.buffer, this.buffer, 0);
            }
        }
        this.updated = true;
    }

    public Image dullImage(Image brightOne) {
        return brightOne;
    }

    public void autoSize() {
        if (this.label != null) {
            this.w = this.myFont.stringWidth(this.label) + 2 * this.buffer;
            this.h = this.myFont.getHeight() + 2 * this.buffer;
        } else if (this.icon != null) {
            this.w = this.icon.getWidth() + 2 * this.buffer;
            this.h = this.icon.getHeight() + 2 * this.buffer;
        } else {
            this.label = "!";
            this.autoSize();
            return;
        }
    }

    public boolean clickedOn(Point p) {
        if (p.x <= (double)(this.x + this.w) && p.x >= (double)this.x && p.y <= (double)(this.y + this.h) && p.y >= (double)this.y) {
            this.wasClicked();
            return true;
        }
        return false;
    }

    public boolean clickedOn(int _x, int _y) {
        if (_x <= this.x + this.w && _x >= this.x && _y <= this.y + this.h && _y >= this.y) {
            this.wasClicked();
            return true;
        }
        return false;
    }

    private void wasClicked() {
        this.clickedAt = System.currentTimeMillis();
        this.clicked = true;
        this.drawAsClicked = true;
        this.updated = false;
        this.myBoss.scriptParser(this.commands);
    }

    public int getWidth() {
        return this.w;
    }

    public void addCommandListener(SpringThing _myBoss) {
        this.myBoss = _myBoss;
    }
}

