/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Random;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorManager;

public class SpringThing
extends MIDlet
implements CommandListener,
DataListener {
    private String version = "0.1.2";
    private int MAXX = 240;
    private int MAXY = 400;
    private double MIND = 20.0;
    private double MAXD = 30.0;
    private Anim anim;
    private int elDiam = 4;
    private int SelElDiam = 6;
    private Color elementColor = new Color(0, 255, 0);
    private Color labelColor = new Color(0, 250, 250);
    private int numDemos = 5;
    private int currDemo = 0;
    private SpringScript[] springDemos = new SpringScript[this.numDemos];
    private Point pressOrigin = new Point(0.0, 0.0);
    private Point lastLoc = new Point(0.0, 0.0);
    private int activeEl = -1;
    private double clickTol = 13.0;
    private boolean dragging = false;
    private boolean traceActiveEl = true;
    private boolean traceAll = false;
    private boolean pause = false;
    private boolean hardPause = false;
    private boolean selecting = false;
    private boolean noErase = false;
    private boolean drawEls = false;
    private boolean drawConstraints = true;
    private double lastE = 0.0;
    private Vector DOS = new Vector(0, 0);
    private Vector zoomCenter;
    private boolean snap = false;
    private boolean grid = false;
    private int gridStep = 20;
    private Color gridColor = new Color(30, 30, 30);
    private boolean stats = false;
    private boolean followSystem = false;
    private Image offImg;
    private Graphics offG;
    private SpringThingDrawer drawSprings;
    private Display display;
    private GraphicsConsole gc;
    private StatusThread statusThread;
    private StatusDrawer statusDrawer;
    private MesherThread mesherThread;
    private Elements ELS;
    private Elements selectedELS = new Elements();
    private Connections CONS;
    private Connections selectedCONS = new Connections();
    private int initNumEls = 70;
    private int conPerEl = 10;
    private double elMass = 1.0;
    private double K = 2700.0;
    private boolean forced = false;
    private double brown = 2.0;
    private Shaker[] Shakers = new Shaker[1000];
    private int numShakers = 0;
    private boolean showForce = true;
    private boolean showVel = false;
    private int forceFactor = 2000;
    private int velFactor = 25;
    private boolean showCons = true;
    private double timeStamp = System.currentTimeMillis();
    private double frameStep = 10.0;
    private long frame = 0L;
    private long surTime = 0L;
    private long startTime = System.currentTimeMillis();
    private Date dateSeed = new Date();
    private Random rnd = new Random(this.dateSeed.getTime());
    private boolean sensorsExist = false;
    private boolean hasAccel = false;
    private int accelNumChannels;
    private SensorInfo[] sensors;
    private SensorInfo[] accelSensors;
    private SensorConnection accelCon;
    private int numSensors;
    private Vector deviceAccel = new Vector(0.0, 0.0, 0.0);
    private boolean gravOn = false;
    private TouchButton clearButton;
    private TouchButton orderedMeshButton;
    private TouchButton forceButton;
    private TouchButton randomMeshButton;
    private TouchButton gButton;
    private TouchButton fixButton;
    private TouchButton freeButton;
    private TouchButton pauseButton;
    private MultiScale ms = new MultiScale();
    private long msMaxEls = 400L;
    private long msMinEls = 30L;
    private long msMaxElsPerSide = 25L;
    private long msMinElsPerSide = 3L;
    private long msMaxConsPerEl = 30L;
    private long msMinConsPerEl = 1L;

    public SpringThing() {
        this.init();
    }

    public void init() {
        this.drawSprings = new SpringThingDrawer();
        this.drawSprings.setFullScreenMode(true);
        this.MAXY = this.drawSprings.getHeight();
        this.MAXX = this.drawSprings.getWidth();
        if (this.MAXX <= 0) {
            this.MAXX = 240;
        }
        if (this.MAXY <= 0) {
            this.MAXY = 400;
        }
        this.zoomCenter = new Vector((double)this.MAXX / 2.0, (double)this.MAXY / 2.0);
        this.initSpringDemos();
        this.initGraphics();
        this.threadMesh(0);
        this.commandLine("rcm 3 1 1\n");
        this.display.setCurrent((Displayable)this.drawSprings);
        this.anim = new Anim(this);
        if (System.getProperty("microedition.sensor.version") != null) {
            this.sensors = SensorManager.findSensors(null, null);
            this.numSensors = this.sensors.length;
            for (int i = 0; i < this.numSensors; ++i) {
                this.longMsg("Sen" + i + ": " + this.sensors[i].getDescription());
            }
            this.longMsg("" + this.numSensors + " sensors found.");
            this.sensorsExist = true;
            this.accelSensors = SensorManager.findSensors((String)"acceleration", null);
            if (this.accelSensors == null) {
                this.longMsg("No accelerometer found. Reduced functionality.");
                this.hasAccel = false;
            } else {
                this.accelNumChannels = this.accelSensors[0].getChannelInfos().length;
                this.longMsg("Found accelerometer: " + this.accelNumChannels + "ax");
                try {
                    this.accelCon = (SensorConnection)Connector.open((String)this.accelSensors[0].getUrl());
                    this.accelCon.setDataListener((DataListener)this, 1);
                    this.longMsg("Accelerometer connected.");
                    this.hasAccel = true;
                }
                catch (IOException e) {
                    this.longMsg("Failed to connect accelerometer.");
                    this.hasAccel = false;
                    e.printStackTrace();
                }
            }
        } else {
            this.sensorsExist = false;
            this.longMsg("No sensors found.");
        }
        this.clearButton = new TouchButton("clear", "C", this.MAXX - 28, this.MAXY - 25);
        this.clearButton.addCommandListener(this);
        this.orderedMeshButton = new TouchButton("om 10 8", "OM", this.MAXX - 28, this.MAXY - 50);
        this.orderedMeshButton.addCommandListener(this);
        this.forceButton = new TouchButton("f", "F", this.MAXX - 28, this.MAXY - 75);
        this.forceButton.addCommandListener(this);
        this.randomMeshButton = new TouchButton("range 10 35\nrm 150 10", "RM", this.MAXX - 28, this.MAXY - 100);
        this.randomMeshButton.addCommandListener(this);
        this.gButton = new TouchButton("g", "G", this.MAXX - 28, this.MAXY - 125);
        this.gButton.addCommandListener(this);
        this.fixButton = new TouchButton("fix", "+", this.MAXX - 28, this.MAXY - 150);
        this.fixButton.addCommandListener(this);
        this.freeButton = new TouchButton("free", "-", this.MAXX - 28, this.MAXY - 175);
        this.freeButton.addCommandListener(this);
        this.pauseButton = new TouchButton("p", "||", this.MAXX - 28, this.MAXY - 200);
        this.pauseButton.addCommandListener(this);
        this.msg("SpringThing Mobile v" + this.version);
        this.msg("(c) 2010 kkava.com");
    }

    public void dataReceived(SensorConnection sc, Data[] data, boolean dataMissed) {
        if (!this.hasAccel || this.accelCon == null) {
            return;
        }
        switch (data[0].getChannelInfo().getDataType()) {
            case 1: {
                if (this.accelNumChannels > 0) {
                    this.deviceAccel.x = data[1].getDoubleValues()[0] * 1000.0;
                }
                if (this.accelNumChannels > 1) {
                    this.deviceAccel.y = data[0].getDoubleValues()[0] * 1000.0;
                }
                if (this.accelNumChannels <= 2) break;
                this.deviceAccel.z = data[2].getDoubleValues()[0] * 1000.0;
                break;
            }
            case 2: {
                if (this.accelNumChannels > 0) {
                    this.deviceAccel.x = data[1].getIntValues()[0] / 1000;
                }
                if (this.accelNumChannels > 1) {
                    this.deviceAccel.y = data[0].getIntValues()[0] / 1000;
                }
                if (this.accelNumChannels <= 2) break;
                this.deviceAccel.z = data[2].getIntValues()[0] / 1000;
                break;
            }
            default: {
                this.deviceAccel.x = 0.0;
                this.deviceAccel.y = 0.0;
                this.deviceAccel.z = 0.0;
            }
        }
    }

    private void threadMesh(int meshType) {
        if (this.ELS != null) {
            this.ELS.status = 0;
        }
        if (this.CONS != null) {
            this.CONS.status = 0;
        }
        if (this.statusDrawer == null) {
            this.statusDrawer = new StatusDrawer();
        }
        this.statusDrawer.setFullScreenMode(true);
        this.msg("threadMesh: statusDrawer inited.");
        this.display.setCurrent((Displayable)this.statusDrawer);
        this.statusThread = new StatusThread(this.statusDrawer);
        this.statusThread.setPriority(10);
        this.statusThread.done = false;
        this.msg("threadMesh: statusThread inited.");
        this.mesherThread = new MesherThread(meshType);
        this.mesherThread.setPriority(5);
        this.msg("threadMesh: mesherThread inited.");
        this.msg("threadMesh: starting mesh threads.");
        this.statusThread.start();
        this.mesherThread.start();
        while (!this.mesherThread.done || !this.statusThread.done) {
            try {
                this.statusThread.join();
                this.mesherThread.join();
            }
            catch (InterruptedException ex) {
                this.longMsg("Mesh threads interrupted.");
                ex.printStackTrace();
            }
        }
        if (!this.statusThread.done || !this.mesherThread.done) {
            this.longMsg("Mesh threads not done, yet joined.");
        }
        this.msg("threadMesh: Threads done.");
        this.display.setCurrent((Displayable)this.drawSprings);
    }

    public void startApp() {
        this.pause = false;
        this.hardPause = false;
    }

    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
    }

    protected void pauseApp() {
        this.hardPause = true;
        this.pause = true;
    }

    public void commandAction(Command c, Displayable d) {
        this.msg("Try clicking here instead.");
    }

    private void initGraphics() {
        this.offImg = Image.createImage((int)this.MAXX, (int)this.MAXY);
        this.offG = this.offImg.getGraphics();
        this.display = Display.getDisplay((MIDlet)this);
        this.gc = new GraphicsConsole(this.MAXX, this.MAXY);
    }

    private void initSpringDemos() {
        this.springDemos[0] = new SpringScript("Demo 1", "clear\nom2 25 10\n\nm 10\nk 10000\nf true\nrcm 4 0 0\n");
        this.springDemos[1] = new SpringScript("Demo 2", "clear\nom 30 6\nm 10\nk 10000\nc true\nrcm 0 4 4\n");
        this.springDemos[2] = new SpringScript("Demo 3", "clear\ngrid 10\nrange 10 12\nrm 1500 15\nm 10\nk 10000\nc true\nf true\nrcm 4 0 0\n");
        this.springDemos[3] = new SpringScript("Demo 4", "c false\nk 20000\n");
        this.springDemos[4] = new SpringScript("Demo 5", "clear\ngrid false\nrange 5 25\nrm 1500 10\nm 10\nk 10000\nc true\nf true\nrcm 4 0 0\n");
    }

    public void mesh(int N, double MIND, double MAXD) {
        this.initNumEls += N;
        Elements oldELS = this.ELS;
        this.ELS = new Elements(N, this.elMass, MIND, MAXD, this.MAXX, this.MAXY);
        this.ELS.initArray();
        if (oldELS != null) {
            this.ELS.addEls(oldELS);
        }
        this.CONS = new Connections(this.ELS, this.conPerEl, this.K);
        this.CONS.buildMesh();
        this.forced = false;
    }

    public void oMesh(int N, int cons) {
        long origNumEls = this.initNumEls;
        if (this.MAXX / N < 2 || this.MAXY / N < 2) {
            this.msg(N + " element ordered mesh too fine.");
            this.msg2("N must be less than " + this.MAXX + ".");
            return;
        }
        int MAXDIM = this.MAXX > this.MAXY ? this.MAXX : this.MAXY;
        for (int i = 0; i < this.MAXX; i += MAXDIM / N) {
            for (int j = 0; j < this.MAXY; j += MAXDIM / N) {
                this.ELS.status = 100 * N / (i * j + 1);
                this.ELS.addEl(new Vector(i, j));
            }
        }
        this.ELS.status = 100;
        this.ELS.delT = 0.005;
        this.CONS = new Connections(this.ELS, cons, this.K);
        this.CONS.buildMesh();
        this.forced = false;
    }

    public void oMesh2(int N, int cons) {
        int start = 0;
        int end = this.MAXX;
        if (this.MAXX / N < 2 || this.MAXY / N < 2) {
            this.msg(N + " element ordered mesh too fine.");
            this.msg2("N must be less than " + this.MAXX + ".");
            return;
        }
        for (int i = 0; i < this.MAXX; i += this.MAXX / N) {
            if (start == 0) {
                start = this.MAXX / (2 * N);
                end = this.MAXX + this.MAXX / (2 * N);
            } else {
                start = 0;
                end = this.MAXX;
            }
            for (int j = start; j < end; j += this.MAXY / N) {
                this.ELS.addEl(new Vector(i, j));
            }
        }
        this.ELS.delT = 0.005;
        this.CONS = new Connections(this.ELS, cons, this.K);
        this.CONS.buildMesh();
        this.forced = false;
    }

    public void clear() {
        this.ELS.clear();
        this.CONS.clear();
        if (this.selectedELS != null) {
            this.selectedELS.clear();
        }
        if (this.selectedCONS != null) {
            this.selectedCONS.clear();
        }
        this.numShakers = 0;
        this.activeEl = -1;
    }

    public void zoom(double delta) {
        this.CONS.scale(delta);
        this.ELS.scale(delta, this.zoomCenter);
        this.gridStep = (int)((double)this.gridStep * delta);
    }

    public void randConstrain(int both, int x, int y) {
        if (this.ELS.numEls > 0) {
            int i;
            for (i = 0; i < both; ++i) {
                int jj = (int)Math.ceil(this.rnd.nextDouble() * (double)(this.ELS.numEls - 1));
                this.ELS.EL[jj].fixedX = true;
                this.ELS.EL[jj].fixedY = true;
            }
            for (i = 0; i < x; ++i) {
                this.ELS.EL[(int)Math.ceil((double)(this.rnd.nextDouble() * (double)(this.ELS.numEls - 1)))].fixedX = true;
            }
            for (i = 0; i < y; ++i) {
                this.ELS.EL[(int)Math.ceil((double)(this.rnd.nextDouble() * (double)(this.ELS.numEls - 1)))].fixedY = true;
            }
        }
    }

    public void start() {
        this.startApp();
    }

    public void stop() {
        this.pauseApp();
    }

    public void scriptParser(String commands) {
        StringTokenizer comm = new StringTokenizer(commands, "\n");
        while (comm.hasMoreTokens()) {
            String cmd = comm.nextToken();
            this.msg(cmd);
            this.commandLine(cmd);
        }
    }

    public void commandLine(String fullCommand) {
        block143: {
            StringTokenizer comm = new StringTokenizer(fullCommand);
            if (!comm.hasMoreTokens()) {
                return;
            }
            String command = comm.nextToken();
            if (command.equals("force")) {
                this.msg("force -- DEPRICATED. use shake force fq");
            } else if (command.equals("k")) {
                try {
                    double num;
                    this.K = num = Double.parseDouble(comm.nextToken());
                    if (this.selectedCONS.numCons > 0) {
                        this.selectedCONS.setAllK(this.K);
                        this.msg("Selected elements set to K = " + this.K + " N/m");
                        break block143;
                    }
                    this.CONS.setAllK(this.K);
                    this.msg("All elements set to K = " + this.K + " N/m");
                }
                catch (NumberFormatException er) {
                    this.msg("Usage: k # - set stiffness");
                }
            } else if (command.equals("m")) {
                try {
                    double num;
                    this.elMass = num = Double.parseDouble(comm.nextToken());
                    if (this.selectedELS.numEls > 0) {
                        this.selectedELS.setAllM(this.elMass);
                        this.msg("Selected elements set to M = " + this.elMass + " kg");
                        break block143;
                    }
                    this.ELS.setAllM(this.elMass);
                    this.msg("All elements set to M = " + this.elMass + " kg");
                }
                catch (NumberFormatException er) {
                    this.msg("Usage: m # - set mass");
                }
            } else if (command.equals("fa")) {
                try {
                    double num;
                    this.brown = num = Double.parseDouble(comm.nextToken());
                    this.msg("forced ampl = " + this.brown + " m");
                }
                catch (NumberFormatException er) {
                    this.msg("Usage: fa # - set forced amplitude");
                }
            } else if (command.equals("ms")) {
                try {
                    double num;
                    this.ELS.distStepMax = num = Double.parseDouble(comm.nextToken());
                    this.msg("Max dist. an element can go in a frame is now " + num + " px");
                }
                catch (NumberFormatException er) {
                    this.msg("Usage: ms # - set distance step control");
                }
            } else if (command.equals("rm")) {
                try {
                    this.initNumEls = Integer.parseInt(comm.nextToken());
                    this.conPerEl = Integer.parseInt(comm.nextToken());
                    this.initNumEls = (int)this.ms.getScale(this.msMinEls, this.msMaxEls);
                    this.msg("Random Mesh " + this.initNumEls + " els, " + this.conPerEl + " cons/el");
                    this.threadMesh(0);
                    this.numShakers = 0;
                }
                catch (NumberFormatException er) {
                    this.msg("Usage: rm # #- remesh with # elements, # cons/el");
                }
                catch (NoSuchElementException er) {
                    this.msg("Usage: rm # #- remesh with # elements, # cons/el");
                }
            } else if (command.equals("om")) {
                try {
                    this.initNumEls = Integer.parseInt(comm.nextToken());
                    this.conPerEl = Integer.parseInt(comm.nextToken());
                    this.initNumEls = (int)this.ms.getScale(this.msMinElsPerSide, this.msMaxElsPerSide);
                    this.msg("Ordered Mesh " + this.initNumEls + " els/side, " + this.conPerEl + " cons/el");
                    this.threadMesh(1);
                    this.numShakers = 0;
                }
                catch (NumberFormatException er) {
                    this.msg("Usage: om # #- ordered remesh with # elements, # cons/el");
                }
                catch (NoSuchElementException er) {
                    this.msg("Usage: om # #- ordered remesh with # elements, # cons/el");
                }
            } else if (command.equals("om2")) {
                try {
                    this.initNumEls = Integer.parseInt(comm.nextToken());
                    this.conPerEl = Integer.parseInt(comm.nextToken());
                    this.initNumEls = (int)this.ms.getScale(this.msMinElsPerSide, this.msMaxElsPerSide);
                    this.msg("Ordered Mesh 2 " + this.initNumEls + " els/side, " + this.conPerEl + " cons/el");
                    this.threadMesh(2);
                    this.numShakers = 0;
                }
                catch (NumberFormatException er) {
                    this.msg("Usage: om2 # #- ordered remesh with # elements, # cons/el, style 2");
                }
                catch (NoSuchElementException er) {
                    this.msg("Usage: om2 # #- ordered remesh with # elements, # cons/el, style 2");
                }
            } else if (command.equals("rcm")) {
                try {
                    int both = Integer.parseInt(comm.nextToken());
                    int x = Integer.parseInt(comm.nextToken());
                    int y = Integer.parseInt(comm.nextToken());
                    this.msg(2 * both + x + y + " DOF removed.");
                    this.randConstrain(both, x, y);
                }
                catch (NumberFormatException er) {
                    this.msg("Usage: rcm # # # - randomly constrain mesh {both,x,y}");
                }
                catch (NoSuchElementException er) {
                    this.msg("Usage: rcm # # # - randomly constrain mesh {both,x,y}");
                }
            } else if (command.equals("fix")) {
                if (this.selectedELS.numEls > 0) {
                    this.selectedELS.fixAll();
                    this.msg("Fixed " + this.selectedELS.numEls + " selected elements.");
                } else {
                    this.msg("Select elements to fix w/ Shift + dragging.");
                }
            } else if (command.equals("fixx")) {
                if (this.selectedELS.numEls > 0) {
                    this.selectedELS.fixAllX();
                    this.msg("Fixed " + this.selectedELS.numEls + " selected elements in X.");
                } else {
                    this.msg("Select elements to fix w/ Shift + dragging.");
                }
            } else if (command.equals("fixy")) {
                if (this.selectedELS.numEls > 0) {
                    this.selectedELS.fixAllY();
                    this.msg("Fixed " + this.selectedELS.numEls + " selected elements in Y.");
                } else {
                    this.msg("Select elements to fix w/ Shift + dragging.");
                }
            } else if (command.equals("range")) {
                try {
                    double min = Double.parseDouble(comm.nextToken());
                    double max = Double.parseDouble(comm.nextToken());
                    this.clickTol = (min + max) / 3.0;
                    this.msg("Range: " + min + " to " + max + "pixels (mesh tolerance - needs remesh to apply)");
                    this.msg("Click tolerance changed to " + min + ".");
                    this.MIND = min;
                    this.MAXD = max;
                }
                catch (NumberFormatException er) {
                    this.msg("Usage: range # # - define mesh tolerance {min, max}");
                }
                catch (NoSuchElementException er) {
                    this.msg("Usage: range # # - define mesh tolerance {min, max}");
                }
            } else if (command.equals("shake")) {
                this.showForce = true;
                if (this.activeEl == -1) {
                    this.msg("Select an element to shake first, then use shake #A #w command.");
                    this.msg2("Use LMB click to select elements.");
                    return;
                }
                try {
                    if (comm.countTokens() == 1) {
                        double A = Double.parseDouble(comm.nextToken());
                        this.addShaker(this.activeEl, A, 1.0);
                        this.msg("Added shaker to EL[" + this.activeEl + "]: A: " + A + " [N], w: " + 1 + " [rad/s]");
                        this.msg2("To set [rad/s] use >shake #A #w");
                        return;
                    }
                    double A = Double.parseDouble(comm.nextToken());
                    double w = Double.parseDouble(comm.nextToken());
                    this.addShaker(this.activeEl, A, w);
                    this.msg("Added shaker to EL[" + this.activeEl + "]: A: " + A + " [N], w: " + w + " [rad/s]");
                    return;
                }
                catch (NumberFormatException er) {
                    this.msg("Usage: shake #A #w - shake selected el A [N] and w [rad/s]");
                }
                catch (NoSuchElementException er) {
                    this.msg("Usage: shake #A #w - shake selected el A [N] and w [rad/s]");
                }
            } else if (command.equals("clear")) {
                this.clear();
                this.msg("Mesh Cleared.");
            } else if (command.equals("free")) {
                if (this.selectedELS.numEls > 0) {
                    this.selectedELS.freeAll();
                    this.msg("" + this.selectedELS.numEls + " elements freed.");
                } else {
                    this.ELS.freeAll();
                    this.msg("All elements freed from constraints.");
                }
            } else if (command.equals("ts")) {
                double delta = Double.parseDouble(comm.nextToken());
                this.ELS.delT = delta / 1000.0;
                this.msg("Time step set to " + delta + "ms");
            } else if (command.equals("sc")) {
                double delta = Double.parseDouble(comm.nextToken());
                this.zoom(delta);
                this.msg("Mesh scaled by " + delta + ".");
            } else if (command.equals("p")) {
                this.pause = !this.pause;
                this.msg("Pause: " + this.pause);
            } else if (command.equals("t")) {
                String flag;
                this.noErase = comm.hasMoreTokens() ? (flag = comm.nextToken()).equals("true") : !this.noErase;
                this.msg("NoErase: " + this.noErase);
            } else if (command.equals("ta")) {
                String flag;
                this.traceAll = comm.hasMoreTokens() ? (flag = comm.nextToken()).equals("true") : !this.traceAll;
                this.msg("Tracking Numbers: " + this.traceAll);
            } else if (command.equals("grid") && comm.hasMoreTokens()) {
                String flag = comm.nextToken();
                try {
                    this.gridStep = Integer.parseInt(flag);
                    this.grid = true;
                    this.msg("Grid: " + this.grid);
                    this.msg2("GridStep: " + this.gridStep);
                }
                catch (NumberFormatException ez) {
                    if (flag.equals("true")) {
                        this.grid = true;
                        break block143;
                    }
                    this.grid = false;
                }
            } else if (command.equals("grid")) {
                this.grid = !this.grid;
                this.msg("Grid: " + this.grid);
                this.msg2("GridStep: " + this.gridStep);
            } else if (command.equals("f")) {
                String flag;
                this.showForce = comm.hasMoreTokens() ? (flag = comm.nextToken()).equals("true") : !this.showForce;
                this.msg("ShowForce: " + this.showForce);
            } else if (command.equals("v")) {
                String flag;
                this.showVel = comm.hasMoreTokens() ? (flag = comm.nextToken()).equals("true") : !this.showVel;
                this.msg("ShowVelocity: " + this.showVel);
            } else if (command.equals("c")) {
                if (comm.hasMoreTokens()) {
                    String flag = comm.nextToken();
                    this.showCons = flag.equals("true");
                    this.msg(flag);
                } else {
                    this.showCons = !this.showCons;
                }
                this.msg("ShowCons: " + this.showCons);
            } else if (command.equals("status")) {
                String flag;
                this.stats = comm.hasMoreTokens() ? (flag = comm.nextToken()).equals("true") : !this.stats;
                this.msg("ShowStatus: " + this.stats);
                this.msg2("    FPS always shown.");
            } else if (command.equals("relax")) {
                int i;
                for (i = 0; i < this.CONS.numCons; ++i) {
                    this.CONS.CON[i].relax();
                }
                for (i = 0; i < this.ELS.numEls; ++i) {
                    this.ELS.EL[i].V = new Vector(0, 0);
                }
            } else if (command.equals("g")) {
                if (comm.hasMoreTokens()) {
                    try {
                        double G = Double.parseDouble(comm.nextToken());
                        for (int i = 0; i < this.ELS.numEls; ++i) {
                            this.ELS.EL[i].G = new Vector(G, 0.0);
                        }
                        this.msg("Gravity set to " + G + " m/s^2.");
                    }
                    catch (NumberFormatException e1) {
                        this.msg("Usage: g # - set gravity to # m/s^2.");
                        this.msg2("Or just g to toggle gravity on or off.");
                    }
                } else {
                    if (this.gravOn) {
                        this.ELS.setGrav(new Vector(0.0, 0.0, 0.0));
                        this.gravOn = false;
                    } else {
                        this.ELS.setGrav(this.deviceAccel);
                        this.gravOn = true;
                    }
                    this.msg("Gravity: " + this.gravOn);
                }
            } else if (command.equals("cn")) {
                if (comm.hasMoreTokens()) {
                    try {
                        int n = Integer.parseInt(comm.nextToken());
                        if (this.selectedELS.numEls > 0) {
                            this.CONS.delSelected();
                            this.selectedCONS = new Connections(this.selectedELS, n);
                            this.selectedCONS.buildMesh();
                            this.selectedCONS.selectAll();
                            this.CONS.addCons(this.selectedCONS);
                            break block143;
                        }
                        this.CONS = new Connections(this.ELS, n);
                        this.CONS.buildMesh();
                    }
                    catch (NumberFormatException e1) {
                        this.msg("Usage: cn # - connect # closest elements.");
                        this.msg2("    OR just cn, default 10 connections/el.");
                    }
                } else {
                    if (this.selectedELS.numEls > 0) {
                        this.selectedCONS.deselect();
                        this.selectedCONS.buildMesh(10);
                    } else {
                        this.CONS.buildMesh(10);
                    }
                    this.msg("Meshed with 10 connections/el.");
                    this.msg2("    use cn # to set more/less connections...");
                }
            } else if (command.equals("d")) {
                if (comm.hasMoreTokens()) {
                    try {
                        double C = Double.parseDouble(comm.nextToken());
                        if (this.selectedELS.numEls > 0) {
                            this.selectedELS.setDamping(C);
                            this.msg("Added " + C + " [Ns/m] damping to " + this.selectedELS.numEls + " selected elements.");
                            break block143;
                        }
                        this.ELS.setDamping(C);
                        this.msg("Added " + C + " [Ns/m] damping to all elements.");
                    }
                    catch (NumberFormatException e1) {
                        this.msg("Add damping: ");
                        this.msg2("Usage: d # - set damping coefficient to # N/(m/s).");
                    }
                } else {
                    this.msg("Add damping: ");
                    this.msg2("Usage: d # - set damping coefficient to # N/(m/s).");
                }
            } else if (command.equals("contact") || command.equals("ctc")) {
                if (this.selectedELS.numEls > 0) {
                    this.selectedCONS.setComprOnly(true);
                } else {
                    this.msg("contact (or ctc) - must select region to turn into compression-only.");
                    this.msg2("usage: contact OR ctc          (toggle)");
                }
            } else if (command.equals("nocontact") || command.equals("nctc")) {
                if (this.selectedELS.numEls > 0) {
                    this.selectedCONS.setComprOnly(false);
                } else {
                    this.msg("nocontact (or nctc) - must select region to remove compression-only from.");
                    this.msg2("usage: nocontact OR nctc          (toggle)");
                }
            } else if (command.equals("")) {
                this.msg2("[K " + this.K + "] [M " + this.elMass + "] [(MIN, MAX) (" + this.MIND + ", " + this.MAXD + ")] [(numEl, numCon) (" + this.ELS.numEls + ", " + this.CONS.numCons + ")]");
            } else if (command.equals("e")) {
                String flag;
                this.drawEls = comm.hasMoreTokens() ? (flag = comm.nextToken()).equals("true") : !this.drawEls;
                this.msg("Draw elements: " + this.drawEls);
            } else if (command.equals("fit")) {
                this.fit();
                this.msg("Fit to screen.");
            } else if (command.equals("follow")) {
                this.followSystem = !this.followSystem;
                this.msg("Follow system: " + this.followSystem);
                this.msg2("usage: follow");
            } else {
                this.msg(command + " -- invalid command.");
            }
        }
    }

    public void msg(String s) {
        this.gc.push(s);
        System.out.println(s);
        System.out.flush();
    }

    public void msg2(String s) {
        this.msg(s);
    }

    public void longMsg(String s) {
        this.gc.push(s, 4000L);
        System.out.println(s);
        System.out.flush();
    }

    public void selectEl(Point click) {
        String fixString = new String(" ");
        boolean oneSelected = false;
        this.selectedELS = new Elements();
        for (int i = 0; i < this.ELS.numEls; ++i) {
            if (!(this.ELS.EL[i].S.dist(click) <= this.clickTol)) continue;
            this.activeEl = i;
            this.selectedELS.addEl(this.ELS.EL[this.activeEl]);
            if (this.ELS.EL[i].fixedX) {
                fixString = fixString.concat("X");
            }
            if (this.ELS.EL[i].fixedY) {
                fixString = fixString.concat("Y");
            }
            this.msg("Element " + i + ": m: " + this.ELS.EL[i].M + " c: " + this.ELS.EL[i].C.x + fixString);
            oneSelected = true;
            break;
        }
        if (!oneSelected) {
            this.activeEl = -1;
        }
    }

    public void selectWithin(Point from, Point to) {
        int i;
        this.selectedELS.deselect();
        this.selectedELS.clear();
        this.selectedCONS.deselect();
        this.selectedCONS.clear();
        double maxx = 0.0;
        double minx = 0.0;
        double maxy = 0.0;
        double miny = 0.0;
        if (from.getX() >= to.getX()) {
            maxx = from.getX();
            minx = to.getX();
        } else {
            maxx = to.getX();
            minx = from.getX();
        }
        if (from.getY() >= to.getY()) {
            maxy = from.getY();
            miny = to.getY();
        } else {
            maxy = to.getY();
            miny = from.getY();
        }
        this.msg("   Select within: (" + minx + ", " + miny + ") - (" + maxx + ", " + maxy + ") {");
        for (i = 0; i < this.ELS.numEls; ++i) {
            if (!this.ELS.EL[i].isIn(minx, miny, maxx, maxy)) continue;
            this.selectedELS.addEl(this.ELS.EL[i]);
            this.ELS.EL[i].selected = true;
        }
        for (i = 0; i < this.CONS.numCons; ++i) {
            if (!this.CONS.CON[i].isAllIn(minx, miny, maxx, maxy)) continue;
            this.msg("      Selected connection " + i + ".");
            this.selectedCONS.addCon(this.CONS.CON[i]);
            this.CONS.CON[i].selected = true;
        }
        this.selectedCONS.setEls(this.selectedELS);
        this.msg("Selected " + this.selectedELS.numEls + " elements and " + this.selectedCONS.numCons + " connections.");
    }

    public void addShaker(int el, double A, double w) {
        this.Shakers[this.numShakers] = new Shaker(el, A, w);
        ++this.numShakers;
    }

    public int dist(Point p1, Point P2) {
        return (int)Math.sqrt(p1.x * p1.x + p1.y * p1.y);
    }

    public void fit() {
        double scaleToFit = 1.0;
        Vector toCenter = new Vector(((double)this.MAXX - (this.ELS.maxx + this.ELS.minx)) / 2.0, ((double)this.MAXY - (this.ELS.maxy + this.ELS.miny)) / 2.0);
        this.ELS.moveAll(toCenter);
        scaleToFit = Math.abs(this.ELS.maxx - this.ELS.minx) / (double)this.MAXX > Math.abs(this.ELS.maxy - this.ELS.miny) / (double)this.MAXY ? (double)this.MAXX / (this.ELS.maxx - this.ELS.minx) : (double)this.MAXY / (this.ELS.maxy - this.ELS.miny);
        this.ELS.scale(scaleToFit, new Vector((double)this.MAXX / 2.0, (double)this.MAXY / 2.0));
        this.CONS.scale(scaleToFit);
    }

    public class SpringScript {
        public String label;
        public int index;
        public String script;

        public SpringScript(String lab, String scr) {
            this.label = lab;
            this.script = scr;
            this.index = -1;
        }

        public SpringScript(int idx, String lab, String scr) {
            this.index = idx;
            this.label = lab;
            this.script = scr;
        }
    }

    public class Anim
    extends Thread {
        private SpringThing a;

        public Anim(SpringThing a) {
            this.a = a;
            this.start();
        }

        public void run() {
            while (true) {
                if (SpringThing.this.hardPause) {
                    continue;
                }
                try {
                    Anim.sleep((long)this.a.frameStep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.a.drawSprings.repaint();
            }
        }
    }

    private class SpringThingDrawer
    extends Canvas {
        private SpringThingDrawer() {
        }

        public void paint(Graphics g) {
            if ((double)System.currentTimeMillis() - SpringThing.this.timeStamp > SpringThing.this.frameStep) {
                int i;
                if (SpringThing.this.followSystem && !SpringThing.this.pause) {
                    SpringThing.this.fit();
                }
                if (!SpringThing.this.noErase) {
                    SpringThing.this.offG.setColor(Color.black.value);
                    SpringThing.this.offG.fillRect(0, 0, SpringThing.this.MAXX, SpringThing.this.MAXY);
                }
                SpringThing.this.frame++;
                if (SpringThing.this.grid) {
                    SpringThing.this.offG.setColor(((SpringThing)SpringThing.this).gridColor.value);
                    for (i = 0; i < SpringThing.this.MAXX; i += SpringThing.this.gridStep) {
                        SpringThing.this.offG.drawLine(i, 0, i, SpringThing.this.MAXY);
                        SpringThing.this.offG.drawLine(0, i, SpringThing.this.MAXX, i);
                    }
                    SpringThing.this.offG.setColor(Color.red.value);
                    SpringThing.this.offG.drawLine(10, 170, 10 + SpringThing.this.gridStep, 170);
                    SpringThing.this.offG.drawLine(10, 167, 10, 173);
                    SpringThing.this.offG.drawLine(10 + SpringThing.this.gridStep, 167, 10 + SpringThing.this.gridStep, 173);
                    SpringThing.this.offG.drawString(SpringThing.this.gridStep + " m", 13 + SpringThing.this.gridStep, 173, 0);
                }
                if (!SpringThing.this.pause && !SpringThing.this.selecting) {
                    SpringThing.this.surTime += (int)(1000.0 * ((SpringThing)SpringThing.this).ELS.delT);
                    SpringThing.this.ELS.updateInertialState();
                }
                SpringThing.this.CONS.updateForceState();
                if (SpringThing.this.showCons) {
                    for (i = 0; i < ((SpringThing)SpringThing.this).CONS.numCons; ++i) {
                        if (!((SpringThing)SpringThing.this).CONS.CON[i].active) continue;
                        int dColor = (int)(Math.abs(((SpringThing)SpringThing.this).CONS.CON[i].F) / 50.0 + 50.0);
                        if (dColor > 255) {
                            dColor = 255;
                        }
                        if (((SpringThing)SpringThing.this).CONS.CON[i].F < 0.0) {
                            SpringThing.this.offG.setColor(0, 50, dColor);
                        } else {
                            SpringThing.this.offG.setColor(dColor, 50, 0);
                        }
                        if (((SpringThing)SpringThing.this).CONS.CON[i].selected) {
                            SpringThing.this.offG.setStrokeStyle(1);
                            SpringThing.this.offG.drawLine((int)((SpringThing)SpringThing.this).CONS.CON[i].EL1.S.x, (int)((SpringThing)SpringThing.this).CONS.CON[i].EL1.S.y, (int)((SpringThing)SpringThing.this).CONS.CON[i].EL2.S.x, (int)((SpringThing)SpringThing.this).CONS.CON[i].EL2.S.y);
                            SpringThing.this.offG.setStrokeStyle(0);
                            continue;
                        }
                        SpringThing.this.offG.drawLine((int)((SpringThing)SpringThing.this).CONS.CON[i].EL1.S.x, (int)((SpringThing)SpringThing.this).CONS.CON[i].EL1.S.y, (int)((SpringThing)SpringThing.this).CONS.CON[i].EL2.S.x, (int)((SpringThing)SpringThing.this).CONS.CON[i].EL2.S.y);
                    }
                }
                if (SpringThing.this.drawEls || SpringThing.this.drawConstraints || SpringThing.this.showForce || SpringThing.this.showVel) {
                    for (i = 0; i < ((SpringThing)SpringThing.this).ELS.numEls; ++i) {
                        Element TE;
                        if (SpringThing.this.drawEls) {
                            SpringThing.this.offG.setColor(((SpringThing)SpringThing.this).elementColor.value);
                            if (((SpringThing)SpringThing.this).ELS.EL[i].selected) {
                                SpringThing.this.offG.fillArc((int)(((SpringThing)SpringThing.this).ELS.EL[i].S.x - (double)(SpringThing.this.SelElDiam / 2)), (int)(((SpringThing)SpringThing.this).ELS.EL[i].S.y - (double)(SpringThing.this.SelElDiam / 2)), SpringThing.this.SelElDiam, SpringThing.this.SelElDiam, 0, 360);
                            } else {
                                SpringThing.this.offG.drawArc((int)(((SpringThing)SpringThing.this).ELS.EL[i].S.x - (double)(SpringThing.this.elDiam / 2)), (int)(((SpringThing)SpringThing.this).ELS.EL[i].S.y - (double)(SpringThing.this.elDiam / 2)), SpringThing.this.elDiam, SpringThing.this.elDiam, 0, 360);
                            }
                            if (SpringThing.this.traceAll) {
                                SpringThing.this.offG.setColor(((SpringThing)SpringThing.this).labelColor.value);
                                SpringThing.this.offG.drawString("" + i, (int)((SpringThing)SpringThing.this).ELS.EL[i].S.x + 1, (int)((SpringThing)SpringThing.this).ELS.EL[i].S.y - 1, 0);
                            }
                            if (i == SpringThing.this.activeEl && SpringThing.this.traceActiveEl) {
                                SpringThing.this.offG.setColor(Color.yellow.value);
                                SpringThing.this.offG.drawString("" + SpringThing.this.activeEl, (int)((SpringThing)SpringThing.this).ELS.EL[i].S.x + 1, (int)((SpringThing)SpringThing.this).ELS.EL[i].S.y - 1, 0);
                            }
                        }
                        if (SpringThing.this.drawConstraints) {
                            SpringThing.this.offG.setColor(Color.white.value);
                            if (((SpringThing)SpringThing.this).ELS.EL[i].fixedY) {
                                SpringThing.this.offG.drawLine((int)(((SpringThing)SpringThing.this).ELS.EL[i].S.x - (double)SpringThing.this.elDiam * 1.2), (int)((SpringThing)SpringThing.this).ELS.EL[i].S.y, (int)(((SpringThing)SpringThing.this).ELS.EL[i].S.x + (double)SpringThing.this.elDiam * 1.2), (int)((SpringThing)SpringThing.this).ELS.EL[i].S.y);
                            }
                            if (((SpringThing)SpringThing.this).ELS.EL[i].fixedX) {
                                SpringThing.this.offG.drawLine((int)((SpringThing)SpringThing.this).ELS.EL[i].S.x, (int)(((SpringThing)SpringThing.this).ELS.EL[i].S.y - (double)SpringThing.this.elDiam * 1.2), (int)((SpringThing)SpringThing.this).ELS.EL[i].S.x, (int)(((SpringThing)SpringThing.this).ELS.EL[i].S.y + (double)SpringThing.this.elDiam * 1.2));
                            }
                        }
                        if (SpringThing.this.showForce) {
                            SpringThing.this.offG.setColor(Color.yellow.value);
                            TE = ((SpringThing)SpringThing.this).ELS.EL[i];
                            SpringThing.this.offG.drawLine((int)TE.S.x, (int)TE.S.y, (int)(TE.S.x + TE.F.x / (double)SpringThing.this.forceFactor), (int)(TE.S.y + TE.F.y / (double)SpringThing.this.forceFactor));
                        }
                        if (!SpringThing.this.showVel) continue;
                        SpringThing.this.offG.setColor(Color.cyan.value);
                        TE = ((SpringThing)SpringThing.this).ELS.EL[i];
                        SpringThing.this.offG.drawLine((int)TE.S.x, (int)TE.S.y, (int)(TE.S.x + TE.V.x / (double)SpringThing.this.velFactor), (int)(TE.S.y + TE.V.y / (double)SpringThing.this.velFactor));
                    }
                }
                if (SpringThing.this.pressOrigin != null && SpringThing.this.lastLoc != null) {
                    SpringThing.this.offG.setColor(Color.red.value);
                    SpringThing.this.offG.drawArc((int)(((SpringThing)SpringThing.this).pressOrigin.x - SpringThing.this.clickTol / 2.0), (int)(((SpringThing)SpringThing.this).pressOrigin.y - SpringThing.this.clickTol / 2.0), (int)SpringThing.this.clickTol, (int)SpringThing.this.clickTol, 0, 360);
                    SpringThing.this.offG.setColor(Color.blue.value);
                    SpringThing.this.offG.drawArc((int)(((SpringThing)SpringThing.this).lastLoc.x - SpringThing.this.clickTol / 2.0), (int)(((SpringThing)SpringThing.this).lastLoc.y - SpringThing.this.clickTol / 2.0), (int)SpringThing.this.clickTol, (int)SpringThing.this.clickTol, 0, 360);
                }
                SpringThing.this.offG.setColor(Color.yellow.value);
                SpringThing.this.offG.drawString("FPS:     " + (int)(1000.0 / ((double)System.currentTimeMillis() - SpringThing.this.timeStamp)), 1, 1, 0);
                if (SpringThing.this.stats) {
                    SpringThing.this.offG.drawString("Simulation Time (ms): " + SpringThing.this.surTime, 10, 32, 0);
                    SpringThing.this.offG.drawString("MeshTime (ms): " + (((SpringThing)SpringThing.this).ELS.placeTime + ((SpringThing)SpringThing.this).CONS.meshTime), 10, 44, 0);
                    if (SpringThing.this.initNumEls != 0) {
                        SpringThing.this.offG.drawString("MeshTime/El (ms): " + (((SpringThing)SpringThing.this).ELS.placeTime + ((SpringThing)SpringThing.this).CONS.meshTime) / (long)SpringThing.this.initNumEls, 10, 56, 0);
                    }
                    SpringThing.this.offG.drawString("TimeStep: " + (int)(((SpringThing)SpringThing.this).ELS.delT * 1000000.0) + " micros", 10, 80, 0);
                    SpringThing.this.offG.drawString("Max Acc: " + (int)((SpringThing)SpringThing.this).ELS.A_max + " m/s^2", 20, 92, 0);
                    SpringThing.this.offG.drawString("Max Vel: " + (int)((SpringThing)SpringThing.this).ELS.V_max + " m/s", 20, 104, 0);
                    SpringThing.this.offG.setColor(Color.green.value);
                    SpringThing.this.offG.drawString("%PE:   " + (int)(((SpringThing)SpringThing.this).CONS.PE / (((SpringThing)SpringThing.this).CONS.PE + ((SpringThing)SpringThing.this).ELS.KE) * 100.0), 20, 116, 0);
                    SpringThing.this.offG.drawString("%KE:   " + (int)(((SpringThing)SpringThing.this).ELS.KE / (((SpringThing)SpringThing.this).CONS.PE + ((SpringThing)SpringThing.this).ELS.KE) * 100.0), 20, 128, 0);
                    SpringThing.this.offG.drawString("E_tot: " + (long)(((SpringThing)SpringThing.this).CONS.PE + ((SpringThing)SpringThing.this).ELS.KE) / 1000L + " KJ", 20, 140, 0);
                    SpringThing.this.offG.drawString("Power: " + (long)((((SpringThing)SpringThing.this).CONS.PE + ((SpringThing)SpringThing.this).ELS.KE - SpringThing.this.lastE) / (1000.0 * ((SpringThing)SpringThing.this).ELS.delT)) + " KW", 20, 152, 0);
                    SpringThing.this.lastE = ((SpringThing)SpringThing.this).CONS.PE + ((SpringThing)SpringThing.this).ELS.KE;
                }
                if (SpringThing.this.selecting && SpringThing.this.pressOrigin != null) {
                    int x = SpringThing.this.pressOrigin.getX() > SpringThing.this.lastLoc.getX() ? (int)SpringThing.this.lastLoc.getX() : (int)SpringThing.this.pressOrigin.getX();
                    int y = SpringThing.this.pressOrigin.getY() > SpringThing.this.lastLoc.getY() ? (int)SpringThing.this.lastLoc.getY() : (int)SpringThing.this.pressOrigin.getY();
                    int width = (int)Math.abs(SpringThing.this.pressOrigin.getX() - SpringThing.this.lastLoc.getX());
                    int height = (int)Math.abs(SpringThing.this.pressOrigin.getY() - SpringThing.this.lastLoc.getY());
                    SpringThing.this.offG.setColor(Color.white.value);
                    SpringThing.this.offG.drawRect(x, y, width, height);
                }
                g.drawImage(SpringThing.this.offImg, 0, 0, 0);
                SpringThing.this.gc.paint(g);
                SpringThing.this.ms.paint(g);
                SpringThing.this.clearButton.paint(g);
                SpringThing.this.orderedMeshButton.paint(g);
                SpringThing.this.forceButton.paint(g);
                SpringThing.this.randomMeshButton.paint(g);
                SpringThing.this.gButton.paint(g);
                SpringThing.this.fixButton.paint(g);
                SpringThing.this.freeButton.paint(g);
                SpringThing.this.pauseButton.paint(g);
                SpringThing.this.timeStamp = System.currentTimeMillis();
            }
        }

        public void pointerPressed(int x, int y) {
            boolean numClicks = true;
            SpringThing.this.pressOrigin = new Point(x, y);
            SpringThing.this.lastLoc = SpringThing.this.pressOrigin;
            if (SpringThing.this.clearButton.clickedOn(x, y)) {
                return;
            }
            if (SpringThing.this.orderedMeshButton.clickedOn(x, y)) {
                return;
            }
            if (SpringThing.this.forceButton.clickedOn(x, y)) {
                return;
            }
            if (SpringThing.this.randomMeshButton.clickedOn(x, y)) {
                return;
            }
            if (SpringThing.this.gButton.clickedOn(x, y)) {
                return;
            }
            if (SpringThing.this.fixButton.clickedOn(x, y)) {
                return;
            }
            if (SpringThing.this.freeButton.clickedOn(x, y)) {
                return;
            }
            if (SpringThing.this.pauseButton.clickedOn(x, y)) {
                return;
            }
            if (SpringThing.this.ms.clickedOn(x, y)) {
                SpringThing.this.msg("MultiScale: " + SpringThing.this.ms.getScale());
                return;
            }
            SpringThing.this.selectEl(SpringThing.this.pressOrigin);
        }

        public void pointerReleased(int x, int y) {
            if (SpringThing.this.ms.getScroll()) {
                SpringThing.this.ms.setScroll(false);
                SpringThing.this.ms.setScale(0.5);
            }
            if (SpringThing.this.selecting) {
                SpringThing.this.selectWithin(SpringThing.this.pressOrigin, SpringThing.this.lastLoc);
                SpringThing.this.msg("Selection ending");
                SpringThing.this.selecting = false;
            }
            if (SpringThing.this.activeEl > -1) {
                ((SpringThing)SpringThing.this).ELS.EL[((SpringThing)SpringThing.this).activeEl].update = true;
            }
            SpringThing.this.selectedELS.activate();
            SpringThing.this.pressOrigin = null;
        }

        public void pointerDragged(int x, int y) {
            Point loc = new Point(x, y);
            if (SpringThing.this.ms.clickedOn(x, y)) {
                SpringThing.this.ms.setScroll(true);
                SpringThing.this.zoom(1.0 + SpringThing.this.ms.getScaleIncrement());
            } else {
                try {
                    SpringThing.this.DOS = new Vector((double)x - ((SpringThing)SpringThing.this).lastLoc.x, (double)y - ((SpringThing)SpringThing.this).lastLoc.y);
                }
                catch (NullPointerException e) {
                    SpringThing.this.msg(e.toString());
                }
                if (SpringThing.this.activeEl == -1) {
                    SpringThing.this.ELS.moveAll(SpringThing.this.DOS);
                } else if (((SpringThing)SpringThing.this).selectedELS.numEls > 0 && SpringThing.this.selectedELS.contains(((SpringThing)SpringThing.this).ELS.EL[SpringThing.this.activeEl])) {
                    SpringThing.this.selectedELS.moveAll(SpringThing.this.DOS);
                    SpringThing.this.selectedELS.deactivate();
                } else {
                    ((SpringThing)SpringThing.this).ELS.EL[((SpringThing)SpringThing.this).activeEl].update = false;
                    ((SpringThing)SpringThing.this).ELS.EL[((SpringThing)SpringThing.this).activeEl].S.x = SpringThing.this.lastLoc.getX();
                    ((SpringThing)SpringThing.this).ELS.EL[((SpringThing)SpringThing.this).activeEl].S.y = SpringThing.this.lastLoc.getY();
                }
                SpringThing.this.lastLoc = loc;
            }
        }
    }

    public class StatusThread
    extends Thread {
        private StatusDrawer drawTo;
        private long pauseFor = 100L;
        private int elsStatus = 0;
        private int consStatus = 0;
        public boolean done = false;

        public StatusThread(StatusDrawer _drawTo) {
            super("StatusThread");
            SpringThing.this.msg("StatusThread: Created.");
            this.drawTo = _drawTo;
        }

        public void run() {
            SpringThing.this.msg("StatusThread: running...");
            this.elsStatus = 0;
            this.consStatus = 0;
            this.done = false;
            while (this.elsStatus < 100 || this.consStatus < 100) {
                if (SpringThing.this.ELS != null) {
                    this.elsStatus = SpringThing.this.ELS.status();
                    SpringThing.this.msg("StatusThread: " + this.elsStatus + "%, " + this.consStatus + "%");
                } else {
                    SpringThing.this.msg("StatusThread: ELS not yet inited.");
                }
                if (SpringThing.this.CONS != null) {
                    this.consStatus = SpringThing.this.CONS.status();
                }
                this.drawTo.repaint();
                try {
                    StatusThread.sleep(this.pauseFor);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.done = true;
        }
    }

    public class StatusDrawer
    extends Canvas {
        public void paint(Graphics g) {
            g.setColor(Color.black.value);
            g.fillRect(0, 0, SpringThing.this.MAXX, SpringThing.this.MAXY);
            if (SpringThing.this.ELS != null) {
                g.setColor(Color.cyan.value);
                g.drawString("Elements:    " + SpringThing.this.ELS.status() + "%", 0, 0, 0);
            }
            if (SpringThing.this.CONS != null) {
                g.setColor(Color.RED.value);
                g.drawString("Connections: " + SpringThing.this.CONS.status() + "%", 0, 13, 0);
            }
        }
    }

    public class MesherThread
    extends Thread {
        public static final int RANDOM = 0;
        public static final int ORDERED = 1;
        public static final int ORDERED2 = 2;
        public boolean done = false;
        public int type = 0;

        public MesherThread(int _type) {
            super("MesherThread:" + _type);
            this.type = _type;
            SpringThing.this.msg("MesherThread: " + this.type);
        }

        public void run() {
            switch (this.type) {
                case 0: {
                    SpringThing.this.msg("MesherThread: RANDOM");
                    SpringThing.this.mesh(SpringThing.this.initNumEls, SpringThing.this.MIND, SpringThing.this.MAXD);
                    this.done = true;
                    SpringThing.this.msg("MesherThread: RANDOM: done.");
                    return;
                }
                case 1: {
                    SpringThing.this.msg("MesherThread: ORDERED");
                    SpringThing.this.oMesh(SpringThing.this.initNumEls, SpringThing.this.conPerEl);
                    this.done = true;
                    SpringThing.this.msg("MesherThread: ORDERED: done.");
                    return;
                }
                case 2: {
                    SpringThing.this.msg("MesherThread: ORDERED2");
                    SpringThing.this.oMesh2(SpringThing.this.initNumEls, SpringThing.this.conPerEl);
                    this.done = true;
                    SpringThing.this.msg("MesherThread: ORDERED2: done");
                    return;
                }
            }
            SpringThing.this.msg("MesherThread: unknown mesh type " + this.type);
            this.done = true;
        }
    }
}

