/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MultiScale {
    private int x = 0;
    private int y = 20;
    private int w = 13;
    private int h = 120;
    private int buttonW;
    private int buttonH = 5;
    private boolean vert = true;
    private boolean pulse = true;
    private boolean scroll = false;
    private Image render;
    private double scale;
    private double lastScale = this.scale = 0.5;
    private Color baseColor = Color.ORANGE;
    private Color scaleColor = Color.GREEN;
    private int bracketLen = 3;

    public MultiScale() {
        this.buttonW = this.w;
    }

    public boolean clickedOn(int _x, int _y) {
        if (_x <= this.x + this.w && _x >= this.x && _y <= this.y + this.h && _y >= this.y || this.scroll) {
            this.scaleTo(_x, _y);
            return true;
        }
        return false;
    }

    public void setScroll(boolean state) {
        this.scroll = state;
    }

    public boolean getScroll() {
        return this.scroll;
    }

    private void scaleTo(int _x, int _y) {
        if (this.vert) {
            this.lastScale = this.scale;
            this.scale = (double)(_y - this.y) / (double)this.h;
        } else {
            this.lastScale = this.scale;
            this.scale = (double)(this.x - _x) / (double)this.w;
        }
    }

    public double getScale() {
        return this.scale;
    }

    public double getScale(double min, double max) {
        return (max - min) * this.scale + min;
    }

    public double getScaleIncrement() {
        return this.lastScale - this.scale;
    }

    public void setScale(double s) {
        this.scale = s;
    }

    public void paint(Graphics g) {
        g.setColor(this.baseColor.value);
        if (this.vert) {
            g.drawLine(this.x, this.y, this.x + this.w, this.y);
            g.drawLine(this.x, this.y, this.x, this.y + this.bracketLen);
            g.drawLine(this.x + this.w, this.y, this.x + this.w, this.y + this.bracketLen);
            g.drawLine(this.x, this.y + this.h, this.x + this.w, this.y + this.h);
            g.drawLine(this.x, this.y + this.h, this.x, this.y + this.h - this.bracketLen);
            g.drawLine(this.x + this.w, this.y + this.h, this.x + this.w, this.y + this.h - this.bracketLen);
        } else {
            g.drawRect(this.x, this.y, this.w, this.h);
        }
        if (this.pulse) {
            this.updateColor();
        }
        g.setColor(this.scaleColor.value);
        if (this.vert) {
            g.fillRect(this.x, this.y + (int)(this.scale * (double)this.h), this.buttonW, this.buttonH);
        } else {
            g.fillRect(this.x + (int)(this.scale * (double)this.w), this.y, this.buttonW, this.buttonH);
        }
    }

    private void updateColor() {
        double intensity = Math.sin(System.currentTimeMillis() / 120L);
        this.scaleColor = this.baseColor.factor(intensity);
    }
}

