/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicsConsole {
    private int MAXX;
    private int MAXY;
    private String[] lines;
    private long[] birthTimes;
    private long[] lifeSpans;
    private long defaultLife;
    private int numLines;
    private int minNumLines;
    private int maxNumLines;
    private Font consoleFont;
    private int x;
    private int y;
    private int w;
    private int h;
    private Color textColor;
    private Color bgColor;
    private Image consoleImage;
    private Graphics consoleGraphics;
    private String prompt;
    private int lineHeight;
    private boolean wrap = false;
    private int textBuffer = 2;
    private String wrapFlag = "\\";
    private String tempLine;
    private boolean updated = false;
    private boolean dynamicWidth = true;
    private boolean dynamicHeight = true;
    private long lastGraphicsUpdate = 0L;
    private long updatePeriod;

    public GraphicsConsole(int _MAXX, int _MAXY) {
        this.MAXX = _MAXX;
        this.MAXY = _MAXY;
        this.minNumLines = this.numLines = 2;
        this.lines = new String[this.numLines];
        this.consoleFont = Font.getFont((int)0, (int)0, (int)8);
        this.lineHeight = this.consoleFont.getHeight();
        this.x = 0;
        this.y = this.MAXY - this.lineHeight * this.numLines - 2 * this.textBuffer;
        this.w = this.MAXX;
        this.h = this.lineHeight * this.numLines + 2 * this.textBuffer;
        this.maxNumLines = this.MAXY / this.lineHeight;
        this.buildConsoleImage();
        this.textColor = Color.green;
        this.bgColor = Color.black;
        this.prompt = new String("");
        this.defaultLife = 2500L;
        this.updatePeriod = 500L;
        this.clearLines();
    }

    public void setPos(int _x, int _y) {
        this.x = _x;
        this.y = _y;
    }

    public void setSize(int _w, int _h) {
        this.w = _w;
        this.h = _h;
    }

    public void setLines(int newNumLines) {
        if (newNumLines < this.minNumLines) {
            return;
        }
        if (newNumLines > this.maxNumLines) {
            newNumLines = this.maxNumLines;
        }
        String[] tempLines = this.lines;
        long[] tempBirthTimes = this.birthTimes;
        long[] tempLifeSpans = this.lifeSpans;
        this.lines = new String[newNumLines];
        this.birthTimes = new long[newNumLines];
        this.lifeSpans = new long[newNumLines];
        this.numLines = newNumLines;
        this.clearLines();
        if (this.lines.length >= tempLines.length) {
            for (int i = 0; i < tempLines.length; ++i) {
                this.lines[i] = tempLines[i];
                this.birthTimes[i] = tempBirthTimes[i];
                this.lifeSpans[i] = tempLifeSpans[i];
            }
        } else {
            for (int i = 0; i < this.lines.length; ++i) {
                this.lines[i] = tempLines[i + (tempLines.length - this.lines.length)];
                this.birthTimes[i] = tempBirthTimes[i + (tempLines.length - this.lines.length)];
                this.lifeSpans[i] = tempLifeSpans[i + (tempLines.length - this.lines.length)];
            }
        }
        this.y = this.MAXY - this.lineHeight * this.numLines - 2 * this.textBuffer;
        if (this.y < 0) {
            this.y = 0;
        }
        this.h = this.lineHeight * this.numLines + 2 * this.textBuffer;
        this.updated = false;
    }

    public void paint(Graphics g) {
        if (System.currentTimeMillis() - this.lastGraphicsUpdate > this.updatePeriod || !this.updated) {
            this.updateConsoleImage();
        }
        g.drawImage(this.consoleImage, this.x, this.y, 0);
    }

    public void push(String s) {
        if (this.dynamicHeight) {
            this.setLines(this.numLines + 1);
        } else {
            for (int i = 0; i < this.numLines - 1; ++i) {
                this.lines[i] = this.lines[i + 1];
                this.birthTimes[i] = this.birthTimes[i + 1];
                this.lifeSpans[i] = this.lifeSpans[i + 1];
            }
        }
        this.lines[this.numLines - 1] = s;
        this.birthTimes[this.numLines - 1] = System.currentTimeMillis();
        this.lifeSpans[this.numLines - 1] = this.defaultLife;
        this.updated = false;
    }

    public void push(String s, long life) {
        if (this.dynamicHeight) {
            this.setLines(this.numLines + 1);
        } else {
            for (int i = 0; i < this.numLines - 1; ++i) {
                this.lines[i] = this.lines[i + 1];
                this.birthTimes[i] = this.birthTimes[i + 1];
                this.lifeSpans[i] = this.lifeSpans[i + 1];
            }
        }
        this.lines[this.numLines - 1] = s;
        this.birthTimes[this.numLines - 1] = System.currentTimeMillis();
        this.lifeSpans[this.numLines - 1] = life;
        this.updated = false;
    }

    public void pop(int line) {
        if (this.numLines <= this.minNumLines || line >= this.numLines) {
            return;
        }
        for (int i = line; i > 0; --i) {
            this.lines[i] = this.lines[i - 1];
            this.birthTimes[i] = this.birthTimes[i - 1];
            this.lifeSpans[i] = this.lifeSpans[i - 1];
        }
        this.setLines(this.numLines - 1);
        this.updated = false;
    }

    public boolean clickedOn(int _x, int _y) {
        return _x <= this.x + this.w && _x >= this.x && _y <= this.y + this.h && _y >= this.y;
    }

    private void clearLines() {
        this.birthTimes = new long[this.numLines];
        this.lifeSpans = new long[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i] = new String("");
            this.birthTimes[i] = System.currentTimeMillis();
            this.lifeSpans[i] = this.defaultLife;
        }
        this.updated = false;
    }

    private void updateConsoleImage() {
        int i;
        this.lastGraphicsUpdate = System.currentTimeMillis();
        if (this.dynamicHeight) {
            for (i = 0; i < this.numLines - this.minNumLines; ++i) {
                if (System.currentTimeMillis() - this.birthTimes[i] <= this.lifeSpans[i]) continue;
                this.pop(i);
                --i;
            }
        }
        if (this.dynamicWidth) {
            this.w = this.longestStringWidth() + 2 * this.textBuffer;
            if (this.w > this.MAXX) {
                this.w = this.MAXX;
            }
            this.buildConsoleImage();
        }
        if (this.bgColor != null) {
            this.consoleGraphics.setColor(this.bgColor.value);
            this.consoleGraphics.fillRect(0, 0, this.w, this.h);
        }
        this.consoleGraphics.setColor(this.textColor.value);
        this.consoleGraphics.drawRect(0, 0, this.w - 1, this.h - 2);
        for (i = 0; i < this.numLines; ++i) {
            this.consoleGraphics.drawString(this.prompt + this.lines[i], 2, 2 + i * this.lineHeight, 0);
        }
        this.updated = true;
    }

    private int longestStringWidth() {
        int maxLen = 0;
        int trialLen = 0;
        for (int i = 0; i < this.numLines; ++i) {
            trialLen = this.consoleFont.stringWidth(this.lines[i]);
            if (trialLen <= maxLen) continue;
            maxLen = trialLen;
        }
        return maxLen;
    }

    private void buildConsoleImage() {
        this.consoleImage = Image.createImage((int)this.w, (int)this.h);
        this.consoleGraphics = this.consoleImage.getGraphics();
        this.consoleGraphics.setFont(this.consoleFont);
    }
}

