/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import java.util.Random;

public class Elements {
    public Element[] EL;
    public int numEls = 0;
    public double M = 1.0;
    private Connections CONS;
    private double MAXX = 240.0;
    private double MAXY = 320.0;
    public double maxx = 0.0;
    public double maxy = 0.0;
    public double minx = 0.0;
    public double miny = 0.0;
    private double MIND = 25.0;
    private double MAXD = 30.0;
    public long failedPoints = 0L;
    public long placeTime = 0L;
    public double delT = 0.001;
    public double A_max = 0.0;
    public double V_max = 0.0;
    public double distStepMax = 1000.0;
    public double KE = 0.0;
    private Random rnd;
    private Date dateSeed;
    public int status = 0;
    public boolean gravOn = false;

    public Elements() {
        this.numEls = 0;
        this.EL = new Element[1000];
        this.dateSeed = new Date();
        this.rnd = new Random(this.dateSeed.getTime());
    }

    public Elements(int N, double mass) {
        System.out.println("    Elements() {");
        this.dateSeed = new Date();
        this.rnd = new Random(this.dateSeed.getTime());
        this.numEls = N;
        this.M = mass;
        this.EL = new Element[this.numEls * 2];
        System.out.println("    } END Elements()");
    }

    public Elements(int N, double mass, double mind, double maxd) {
        this.dateSeed = new Date();
        this.rnd = new Random(this.dateSeed.getTime());
        System.out.println("    Elements() {");
        this.MIND = mind;
        this.MAXD = maxd;
        this.M = mass;
        this.numEls = N;
        this.EL = new Element[this.numEls * 2];
        System.out.println("    } END Elements()");
    }

    public Elements(int N, double mass, double mind, double maxd, int _MAXX, int _MAXY) {
        this.dateSeed = new Date();
        this.rnd = new Random(this.dateSeed.getTime());
        System.out.println("    Elements() {");
        this.MIND = mind;
        this.MAXD = maxd;
        this.MAXX = _MAXX;
        this.MAXY = _MAXY;
        this.M = mass;
        this.numEls = N;
        this.EL = new Element[this.numEls * 2];
        System.out.println("    } END Elements()");
    }

    public void setCons(Connections newCons) {
        this.CONS = newCons;
    }

    public void initArray() {
        int totalElements = this.numEls;
        System.out.println("        Elements.initArray() {");
        this.placeTime = System.currentTimeMillis();
        long lastTimePlaced = System.currentTimeMillis();
        this.numEls = 0;
        this.EL[this.numEls] = new Element(new Vector(this.MAXX / 2.0, this.MAXY / 2.0));
        this.EL[this.numEls].myIndex = this.numEls;
        ++this.numEls;
        this.minx = this.MAXX / 2.0 - 1.2 * this.MAXD;
        this.miny = this.MAXY / 2.0 - 1.2 * this.MAXD;
        this.maxx = this.MAXX / 2.0 + 1.2 * this.MAXD;
        this.maxy = this.MAXY / 2.0 + 1.2 * this.MAXD;
        do {
            boolean closeEnough = false;
            boolean tooClose = false;
            Vector s = new Vector(this.minx + this.rnd.nextDouble() * (this.maxx - this.minx), this.miny + this.rnd.nextDouble() * (this.maxy - this.miny));
            for (int j = 0; j < this.numEls; ++j) {
                if (this.EL[j].S.dist(s) < this.MIND) {
                    tooClose = true;
                    break;
                }
                if (!(this.EL[j].S.dist(s) < this.MAXD)) continue;
                closeEnough = true;
            }
            if (closeEnough && !tooClose) {
                if (this.numEls >= this.EL.length) {
                    this.makeRoom();
                }
                this.EL[this.numEls] = new Element(s);
                this.EL[this.numEls].myIndex = this.numEls;
                System.out.println("            Placed point " + this.numEls + " in " + (System.currentTimeMillis() - lastTimePlaced) + "ms (" + this.minx + ", " + this.maxx + ")");
                lastTimePlaced = System.currentTimeMillis();
                ++this.numEls;
                if (this.minx > s.x - 1.2 * this.MAXD) {
                    this.minx = s.x - 1.2 * this.MAXD;
                }
                if (this.miny > s.y - 1.2 * this.MAXD) {
                    this.miny = s.y - 1.2 * this.MAXD;
                }
                if (this.maxx < s.x + 1.2 * this.MAXD) {
                    this.maxx = s.x + 1.2 * this.MAXD;
                }
                if (this.maxy < s.y + 1.2 * this.MAXD) {
                    this.maxy = s.y + 1.2 * this.MAXD;
                }
            } else {
                ++this.failedPoints;
            }
            this.status = 100 * this.numEls / (totalElements - 1);
        } while (this.numEls <= totalElements);
        this.status = 100;
        this.placeTime = System.currentTimeMillis() - this.placeTime;
        System.out.println("            Placed " + this.numEls + " elements in " + this.placeTime + "ms");
        System.out.println("        } END Elements.initArray()");
        this.maxy = 0.0;
        this.miny = 0.0;
        this.maxx = 0.0;
        this.minx = 0.0;
    }

    public int status() {
        return this.status;
    }

    public void addEls(Elements els) {
        for (int i = 0; i < els.numEls; ++i) {
            this.addEl(els.EL[i]);
        }
    }

    public void addEl(Vector s) {
        if (this.EL.length <= this.numEls) {
            this.makeRoom();
        }
        this.EL[this.numEls] = new Element(s);
        this.EL[this.numEls].myIndex = this.numEls;
        ++this.numEls;
    }

    public void addEl(Element e) {
        if (this.EL.length - 1 < this.numEls) {
            this.makeRoom();
        }
        this.EL[this.numEls] = e;
        ++this.numEls;
    }

    public void makeRoom() {
        Element[] oldEL = this.EL;
        this.EL = new Element[this.EL.length * 2];
        for (int i = 0; i < this.numEls; ++i) {
            this.EL[i] = oldEL[i];
        }
    }

    public void updateInertialState() {
        this.V_max = 0.0;
        this.A_max = 0.0;
        this.KE = 0.0;
        this.miny = 100000.0;
        this.minx = 100000.0;
        this.maxy = -100000.0;
        this.maxx = -100000.0;
        for (int i = 0; i < this.numEls; ++i) {
            if (this.EL[i].S.x > this.maxx) {
                this.maxx = this.EL[i].S.x;
            }
            if (this.EL[i].S.x < this.minx) {
                this.minx = this.EL[i].S.x;
            }
            if (this.EL[i].S.y > this.maxy) {
                this.maxy = this.EL[i].S.y;
            }
            if (this.EL[i].S.y < this.miny) {
                this.miny = this.EL[i].S.y;
            }
            this.EL[i].update(this.delT);
            this.KE += 0.5 * this.EL[i].V.mag() * this.EL[i].V.mag();
            if (this.EL[i].V.mag() > this.V_max) {
                this.V_max = this.EL[i].V.mag();
            }
            if (!(this.EL[i].A.mag() > this.A_max)) continue;
            this.A_max = this.EL[i].A.mag();
        }
        if (this.A_max != 0.0 && this.V_max != 0.0) {
            this.delT = ((Math.sqrt(this.V_max * this.V_max + 2.0 * this.A_max * this.distStepMax) - this.V_max) / this.A_max + this.delT) / 2.0;
        }
        if (this.delT > 0.005) {
            this.delT = 0.005;
        }
    }

    public void moveAll(Vector os) {
        for (int i = 0; i < this.numEls; ++i) {
            this.EL[i].S.addTo(os);
        }
    }

    public void scale(double factor, Vector zoomCenter) {
        for (int i = 0; i < this.numEls; ++i) {
            Element e = this.EL[i];
            e.S.x = (e.S.x - zoomCenter.x) * factor + zoomCenter.x;
            e.S.y = (e.S.y - zoomCenter.y) * factor + zoomCenter.y;
            e.V.x *= factor;
            e.V.y *= factor;
            e.A.x *= factor;
            e.A.y *= factor;
        }
    }

    public int[] closestN(int el, int N) {
        int i;
        int forSwap = 0;
        int[] close = new int[N];
        Vector pos = this.EL[el].S;
        for (i = 0; i < N; ++i) {
            close[i] = i;
        }
        for (i = 0; i < this.numEls; ++i) {
            double dist = pos.dist(this.EL[i].S);
            if (i == el) continue;
            for (int k = 0; k < N; ++k) {
                if (!(pos.dist(this.EL[close[k]].S) > dist)) continue;
                forSwap = close[k];
                close[k] = i;
                if (k <= 0) continue;
                close[k - 1] = forSwap;
            }
        }
        return close;
    }

    public void setAllM(double newM) {
        for (int i = 0; i < this.numEls; ++i) {
            this.EL[i].M = newM;
        }
    }

    public void clear() {
        for (int i = 0; i < this.numEls; ++i) {
            this.EL[i].selected = false;
        }
        this.numEls = 0;
    }

    public void deselect() {
        for (int i = 0; i < this.numEls; ++i) {
            this.EL[i].selected = false;
        }
    }

    public void fixAll() {
        for (int i = 0; i < this.numEls; ++i) {
            this.EL[i].fixedX = true;
            this.EL[i].fixedY = true;
        }
    }

    public void fixAllX() {
        for (int i = 0; i < this.numEls; ++i) {
            this.EL[i].fixedX = true;
        }
    }

    public void fixAllY() {
        for (int i = 0; i < this.numEls; ++i) {
            this.EL[i].fixedY = true;
        }
    }

    public void freeAll() {
        for (int i = 0; i < this.numEls; ++i) {
            this.EL[i].update = true;
            this.EL[i].fixedX = false;
            this.EL[i].fixedY = false;
        }
    }

    public void setGrav(Vector _G) {
        for (int i = 0; i < this.numEls; ++i) {
            this.EL[i].G = _G;
        }
        this.gravOn = !_G.equals(new Vector(0.0, 0.0, 0.0));
    }

    public void setDamping(double C) {
        for (int i = 0; i < this.numEls; ++i) {
            this.EL[i].C = new Vector(C, C, C);
        }
    }

    public boolean contains(Element e) {
        for (int i = 0; i < this.numEls; ++i) {
            if (this.EL[i] != e) continue;
            return true;
        }
        return false;
    }

    public void activate() {
        for (int i = 0; i < this.numEls; ++i) {
            this.EL[i].update = true;
        }
    }

    public void deactivate() {
        for (int i = 0; i < this.numEls; ++i) {
            this.EL[i].update = false;
        }
    }
}

