/*
 * Decompiled with CFR 0.152.
 */
public class Element {
    public Vector S;
    public Vector V;
    public Vector A;
    public Vector C;
    public double M = 1.0;
    public boolean fixedX = false;
    public boolean fixedY = false;
    public boolean update = true;
    public int maxCons = 20;
    private Connections localCONS = new Connections();
    public int myIndex;
    public boolean selected = false;
    public Vector G = new Vector(0.0, 9.81);
    public Vector F = new Vector(0, 0);

    public Element(Vector pos) {
        this.S = pos;
        this.V = new Vector(0, 0);
        this.A = new Vector(0, 0);
        this.C = new Vector(2.0, 2.0);
        this.M = 1.0;
        this.localCONS.clear();
    }

    public Element(Vector pos, double m) {
        this.S = pos;
        this.V = new Vector(0, 0);
        this.A = new Vector(0, 0);
        this.C = new Vector(2.0, 2.0);
        this.M = m;
        this.localCONS.clear();
    }

    public Element(double x, double y) {
        this.S = new Vector(x, y);
        this.V = new Vector(0, 0);
        this.A = new Vector(0, 0);
        this.C = new Vector(2.0, 2.0);
        this.M = 1.0;
        this.localCONS.clear();
    }

    public Element(double x, double y, double m) {
        this.S = new Vector(x, y);
        this.V = new Vector(0, 0);
        this.A = new Vector(0, 0);
        this.C = new Vector(2.0, 2.0);
        this.M = m;
        this.localCONS.clear();
    }

    public void addCon(Connection conn) {
        this.localCONS.addCon(conn);
    }

    public void clearCons() {
        this.localCONS.clear();
    }

    public void update(double delT) {
        if (!this.update) {
            return;
        }
        this.F = new Vector(0.0, 0.0, 0.0);
        for (int j = 0; j < this.localCONS.numCons; ++j) {
            try {
                this.F.addTo(this.localCONS.CON[j].forceOn(this));
                continue;
            }
            catch (NumberFormatException e) {
                System.out.println("NaN: forceOn(" + this.myIndex + ") from local connection " + j + ".");
                return;
            }
            catch (NullPointerException npe) {
                System.out.println("NULL POINTER: EL[" + this.myIndex + "].CONIDX[" + j + "] DNE.");
                System.out.println("              CON[" + j + "] referenced.");
                return;
            }
        }
        this.F.addTo(new Vector(this.M * this.G.x, this.M * this.G.y));
        this.F.addTo(new Vector(-1.0 * this.V.x * this.C.x, -1.0 * this.V.y * this.C.y));
        if (!this.fixedX) {
            this.A.x = this.F.x / this.M;
            this.V.x += this.A.x * delT;
            this.S.x += this.V.x * delT + 0.5 * this.A.x * delT * delT;
        }
        if (!this.fixedY) {
            this.A.y = this.F.y / this.M;
            this.V.y += this.A.y * delT;
            this.S.y += this.V.y * delT + 0.5 * this.A.y * delT * delT;
        }
    }

    public void update(Vector f, double delT) {
        if (!this.update) {
            return;
        }
        this.F = f;
        if (!this.fixedX) {
            this.A.x = this.F.x / this.M;
            this.V.x += this.A.x * delT;
            this.S.x += 0.5 * this.A.x * delT * delT + this.V.x * delT;
        }
        if (!this.fixedY) {
            this.A.y = this.F.y / this.M;
            this.V.y += this.A.y * delT;
            this.S.y += 0.5 * this.A.y * delT * delT + this.V.y * delT;
        }
    }

    public boolean isIn(double minx, double miny, double maxx, double maxy) {
        return this.S.x > minx && this.S.x < maxx && this.S.y > miny && this.S.y < maxy;
    }
}

