/*
 * Decompiled with CFR 0.152.
 */
public class Connections {
    public double K = 2700.0;
    public int numCons;
    private int targetCons;
    private Elements ELS;
    public Connection[] CON;
    public long meshTime = 0L;
    public double maxF = 2000000.0;
    public boolean fail = false;
    public double PE = 0.0;
    public int status = 0;

    public Connections() {
        this.CON = new Connection[1000];
        this.numCons = 0;
    }

    public Connections(Elements els, int N, double k) {
        System.out.println("    Connections() {");
        this.targetCons = N;
        this.CON = new Connection[els.numEls * N];
        this.K = k;
        this.ELS = els;
        System.out.println("    } END Connections.");
    }

    public Connections(Elements els, int N) {
        System.out.println("    Connections() {");
        this.targetCons = N;
        this.CON = new Connection[els.numEls * N];
        this.ELS = els;
        System.out.println("    } END Connections.");
    }

    public void setEls(Elements newEls) {
        this.ELS = newEls;
    }

    public void updateForceState() {
        this.PE = 0.0;
        for (int i = 0; i < this.numCons; ++i) {
            this.CON[i].update();
            if (this.fail && this.CON[i].F > this.maxF) {
                this.CON[i].active = false;
            }
            this.PE += 0.5 * this.CON[i].K * this.CON[i].X * this.CON[i].X;
        }
    }

    public void buildCon(Element el1, Element el2) {
        if (this.CON.length - 1 < this.numCons) {
            this.makeRoom();
        }
        this.CON[this.numCons] = new Connection(el1, el2, this.K);
        el1.addCon(this.CON[this.numCons]);
        el2.addCon(this.CON[this.numCons]);
        System.out.println("            Connection " + this.numCons + " (" + el1.myIndex + ", " + el2.myIndex + ")");
        ++this.numCons;
    }

    public void addCon(Connection c) {
        if (this.CON.length <= this.numCons) {
            this.makeRoom();
        }
        this.CON[this.numCons] = c;
        ++this.numCons;
    }

    public void addCons(Connections cs) {
        for (int i = 0; i < cs.numCons; ++i) {
            this.addCon(cs.CON[i]);
        }
    }

    public void delCon(Connection c) {
        for (int i = 0; i < this.numCons; ++i) {
            if (this.CON[i] != c) continue;
            this.delCon(i);
            return;
        }
    }

    public void delCon(int conPos) {
        for (int i = conPos; i < this.numCons - 1; ++i) {
            this.CON[i] = this.CON[i + 1];
        }
        --this.numCons;
    }

    public void delSelected() {
        for (int i = 0; i < this.numCons; ++i) {
            if (!this.CON[i].selected) continue;
            this.delCon(i);
            --i;
        }
    }

    public void selectAll() {
        for (int i = 0; i < this.numCons; ++i) {
            this.CON[i].selected = true;
        }
    }

    public void makeRoom() {
        Connection[] oldCON = this.CON;
        this.CON = new Connection[this.CON.length * 2];
        for (int i = 0; i < this.numCons; ++i) {
            this.CON[i] = oldCON[i];
        }
    }

    public void buildMesh() {
        this.buildMesh(this.targetCons);
    }

    public void buildMesh(int N) {
        this.status = 0;
        System.out.println("        Connections.buildMesh(int N) {");
        if (this.ELS.numEls < N) {
            System.out.println("        \tError: Number of elements is less than number of desired connections per element.");
            System.out.println("        \tAdjusting cons / el.");
            N = this.ELS.numEls - 1;
        }
        this.clear();
        this.clearEls();
        this.meshTime = System.currentTimeMillis();
        int[] close = new int[N];
        for (int i = 0; i < this.ELS.numEls; ++i) {
            close = this.ELS.closestN(i, N);
            for (int j = 0; j < N; ++j) {
                if (this.exists(this.ELS.EL[i], this.ELS.EL[close[j]])) continue;
                this.buildCon(this.ELS.EL[i], this.ELS.EL[close[j]]);
            }
            this.status = 100 * i / this.ELS.numEls;
        }
        this.status = 100;
        this.meshTime = System.currentTimeMillis() - this.meshTime;
        System.out.println("\t        meshTime: " + this.meshTime);
        System.out.println("        } END buildMesh.");
    }

    public int status() {
        return this.status;
    }

    public boolean exists(Element el1, Element el2) {
        for (int i = 0; i < this.numCons; ++i) {
            if (!(this.CON[i].EL1 == el1 && this.CON[i].EL2 == el2 || this.CON[i].EL2 == el1 && this.CON[i].EL1 == el2) && el1 != el2) continue;
            System.out.println("            Redundant connection avoided: (" + el1.myIndex + ", " + el2.myIndex + ")");
            return true;
        }
        return false;
    }

    public void clear() {
        for (int i = 0; i < this.numCons; ++i) {
            this.CON[i].selected = false;
        }
        this.numCons = 0;
    }

    public void clearEls() {
        for (int i = 0; i < this.ELS.numEls; ++i) {
            this.ELS.EL[i].clearCons();
        }
    }

    public void scale(double factor) {
        for (int i = 0; i < this.numCons; ++i) {
            this.CON[i].L *= factor;
        }
    }

    public void setAllK(double k) {
        this.K = k;
        for (int i = 0; i < this.numCons; ++i) {
            this.CON[i].K = k;
        }
    }

    public void deselect() {
        for (int i = 0; i < this.numCons; ++i) {
            this.CON[i].selected = false;
        }
    }

    public void setComprOnly(boolean bt) {
        for (int i = 0; i < this.numCons; ++i) {
            this.CON[i].compressionOnly = bt;
        }
    }
}

