/*
 * Decompiled with CFR 0.152.
 */
public class Connection {
    public Element EL1;
    public Element EL2;
    public double L;
    public double X;
    public double F;
    public double K;
    public boolean active = true;
    public boolean selected = false;
    public boolean compressionOnly = false;

    public Connection(Element e1, Element e2, double k) {
        this.EL1 = e1;
        this.EL2 = e2;
        this.K = k;
        this.F = 0.0;
        this.L = this.EL1.S.dist(this.EL2.S);
        this.X = 0.0;
    }

    public Vector forceOn(Element el) {
        Element otherEl;
        if (el == this.EL1) {
            otherEl = this.EL2;
        } else if (el == this.EL2) {
            otherEl = this.EL1;
        } else {
            System.out.println("    Connection.forceOn(" + el.myIndex + ") is invalid.");
            System.out.println("       -> Connection is only between " + this.EL1.myIndex + " and " + this.EL2.myIndex + ".");
            return new Vector(0, 0);
        }
        Vector unitVec = otherEl.S.subtract(el.S).unitV();
        unitVec.x *= this.F;
        unitVec.y *= this.F;
        return unitVec;
    }

    public void update() {
        this.X = this.EL1.S.dist(this.EL2.S) - this.L;
        if (this.compressionOnly && this.X > 0.0) {
            this.F = 0.0;
            this.active = false;
        } else {
            this.F = this.K * this.X;
            this.active = true;
        }
    }

    public void relax() {
        this.L = this.EL1.S.dist(this.EL2.S);
    }

    public boolean isIn(double minx, double miny, double maxx, double maxy) {
        Vector S = this.EL1.S;
        Vector S2 = this.EL2.S;
        return S.x > minx && S.x < maxx && S.y > miny && S.y < maxy || S2.x > minx && S2.x < maxx && S2.y > miny && S2.y < maxy;
    }

    public boolean isAllIn(double minx, double miny, double maxx, double maxy) {
        Vector S = this.EL1.S;
        Vector S2 = this.EL2.S;
        return S.x > minx && S.x < maxx && S.y > miny && S.y < maxy && S2.x > minx && S2.x < maxx && S2.y > miny && S2.y < maxy;
    }
}

